/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageOne
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernInformantDialogPageOne.class);
    private final ICityPlayerProxyJFX city;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernInformantDialogPageOne(ICityPlayerProxyJFX city) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.informant = this.tavernState.getInformant();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.title", new Object[]{this.informant.getName()}, this.locale.getCurrentLocal()));
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        int price = this.informant.getPrice((IPlayer)this.city.getPlayer());
        parameters.put("price", price);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.buy", new Object[0], this.locale.getCurrentLocal()));
        acceptButton.getStyleClass().add((Object)"actionButton");
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            try {
                this.city.getPlayer().getCompany().updateCash((long)(-price));
                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)EDialogType.TAVERN_INFORMANT_2));
            }
            catch (RuntimeException e) {
                log.error("Failed to accept informant offer", (Throwable)e);
            }
        });
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

