/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPatrolDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernPatrolDialog.class);
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernPatrolDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getPatrol());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.PatrolState.noticeboardTitle", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IPatrol patrol = (IPatrol)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPatrolDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("patrolName", patrol.getName());
        parameters.put("price", patrol.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IPatrol patrol = (IPatrol)this.currentPerson.get();
                PatrolInternalState patrolState = new PatrolInternalState(patrol.getPremium(), patrol.getBonus(), patrol.getDestinations());
                IShip ship = null;
                if (this.city.getActiveShip() instanceof IShip) {
                    ship = (IShip)this.city.getActiveShip();
                }
                IHumanPlayer player = this.city.getPlayer();
                IAttackListener attackListener = this.eventHandlerFactory.getAttackListener(ship, patrolState);
                int minutes = this.rnd.nextInt(600);
                LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
                String cityName = patrolState.nextDestination().get().getName();
                DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.TavernPatrolDialog.title").messageKey("ch.sahits.game.openpatrician.display.dialog.TavernPatrolDialog.acceptMessage").messageArgs(new Object[]{ship.getName(), cityName}).build();
                this.taskFactory.getPostponedDisplayDialogMessage(postMessage, EMessageCategory.TRADE, template);
                LocalDateTime firstDeadline = this.date.getCurrentDate().plusDays(6L);
                this.eventHandlerFactory.getNextPatrolStation((INavigableVessel)ship, patrolState.nextDestination().get(), patrolState, (IPlayer)player, firstDeadline, attackListener);
                patrol.leave();
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to accept patrol offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                for (IShip ship : TavernPatrolDialog.this.city.getPlayersShips()) {
                    if (ship.getCaptian() == null) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

