/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTravelerDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernTravelerDialog.class);
    @Autowired
    private TavernDialogUtil tavernUtil;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private ClientServerFactory clientServerFactory;
    private final ICityPlayerProxyJFX city;
    private final TavernState tavernState;
    private final ITraveler traveler;

    public TavernTravelerDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.traveler = this.tavernState.getTraveler();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IHumanPlayer player = this.city.getPlayer();
        LocalDateTime arrivalDate = this.traveler.getArrivalAtDestinationDate();
        String d = this.modelTranslator.toDisplayString(arrivalDate);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialog", new Object[]{this.city.getPlayer().getLastName(), this.modelTranslator.getLocalDisplayName(player.getCareerLevel()), player.getName(), this.traveler.getDestination().getName(), d}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", this.traveler.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        acceptButton.getStyleClass().add((Object)"actionButton");
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            try {
                IShip ship = (IShip)this.city.getActiveShip();
                if (ship != null) {
                    ship.addPassenger((IPerson)this.traveler);
                    LocalDateTime now = this.date.getCurrentDate();
                    LocalDateTime deadline = now.plusMonths(1L);
                    LinearDeadlinePremiumCalculator premiumCalculator = this.clientServerFactory.premiumCalculator(now, deadline, this.traveler.getPremium());
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{this.traveler.getDestination().getName(), ship.getName(), this.clientServerFactory.dateSupplier(), premiumCalculator});
                    this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, this.traveler.getDestination(), (IPlayer)this.city.getPlayer(), deadline, EDialogTemplateType.TRAVELER_LEAVES_SHIP, parameterSupplier, premiumCalculator);
                    this.clientEventBus.post((Object)new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.acceptMessage", new Object[]{ship.getName()}));
                    this.executeOnCloseButtonClicked();
                    this.traveler.leave();
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to accept traveler on ship", (Throwable)e);
            }
        });
        BooleanBinding disable = this.disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener((observableValue, oldValue, newValue) -> acceptButton.setDisable(newValue.booleanValue()));
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding(){
            {
                for (IShip ship : TavernTravelerDialog.this.city.getPlayersShips()) {
                    super.bind(new Observable[]{ship.passengerPresentProperty()});
                }
            }

            protected boolean computeValue() {
                if (TavernTravelerDialog.this.city.getActiveShip() != null && TavernTravelerDialog.this.city.getActiveShip() instanceof IShip) {
                    return ((IShip)TavernTravelerDialog.this.city.getActiveShip()).getPassenger().isPresent();
                }
                return false;
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

