/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.MapSegmentImageFactory;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTreasureMapOwnerDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernTreasureMapOwnerDialog.class);
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;
    @Autowired
    private MapLocationDetectionModel locationDetector;

    public TavernTreasureMapOwnerDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getTreasureMap());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTreasureMapOwnerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ITreasureMapOwner mapOwner = (ITreasureMapOwner)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTreasureMapOwnerDialog.dialog", new Object[]{this.city.getPlayer().getLastName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", mapOwner.getPrice());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                this.removeDecoratedContent();
                this.removeAcceptButton();
                MapSegmentedImage imageMap = this.segmentFactory.getRandomTreasureNest();
                String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTreasureMapOwnerDialog.acceptMessage", new Object[]{imageMap.getImageName()}, this.locale.getCurrentLocal());
                HashMap parameters = new HashMap();
                ArrayList visibleSegs = new ArrayList(imageMap.getSegmentIndices());
                parameters.put("visibleSegments", visibleSegs);
                DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
                Platform.runLater(() -> this.getContent().add((Object)dt));
                IHumanPlayer player = this.city.getPlayer();
                player.setSegmentedMap(imageMap);
                this.locationDetector.addSegment(imageMap);
                ITreasureMapOwner mapOwner = (ITreasureMapOwner)this.currentPerson.get();
                player.getCompany().updateCash((long)(-mapOwner.getPrice()));
                mapOwner.leave();
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to add treasure map owners offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

