/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.display.event.task.WarehouseTenantPayTimedTask;
import ch.sahits.game.openpatrician.display.event.task.WarehouseTentantLeaveTimedTask;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernWarehouseTenantDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernWarehouseTenantDialog.class);
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList list;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernWarehouseTenantDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getWarehouseTenant());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWarehouseTenantDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IWarehouseTenant tenant = (IWarehouseTenant)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWarehouseTenantDialog.dialog", new Object[]{tenant.getName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", tenant.getAmount());
        parameters.put("price", tenant.getRentPerWeek());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IHumanPlayer player = this.city.getPlayer();
                IWarehouseTenant tenant = (IWarehouseTenant)this.currentPerson.get();
                Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
                if (optOffice.isPresent()) {
                    ITradingOffice office = (ITradingOffice)optOffice.get();
                    office.setOccupiedSpace(office.getOccupiedSpace() + tenant.getAmount());
                    int weeks = this.rnd.nextInt(15) + 5;
                    LocalDateTime currentDate = this.date.getCurrentDate();
                    for (int i = 0; i < weeks; ++i) {
                        currentDate = currentDate.plusWeeks(1L);
                        WarehouseTenantPayTimedTask task = this.taskFactory.getWarehouseTenantPayment((IPlayer)player, tenant, currentDate);
                        this.list.add((TimedTask)task);
                    }
                    WarehouseTentantLeaveTimedTask task = this.taskFactory.getWarehouseTenantLeaving(office, tenant, this.date.getCurrentDate().plusWeeks(weeks));
                    this.list.add((TimedTask)task);
                    tenant.leave();
                }
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to accept warehouse tentants offer offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return !TavernWarehouseTenantDialog.this.city.getPlayer().findTradingOffice(TavernWarehouseTenantDialog.this.city.getCity()).isPresent();
            }
        };
    }
}

