/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.data;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import java.util.Optional;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.EVENT_OBJECT})
public final class DelayedTravelToEvent
implements IEventMetaDataProvider {
    private final Point2D destination;
    private final INavigableVessel vessel;
    @OptionalType(value=ICity.class)
    private final Optional<ICity> city;
    private final String className;
    private final String methodName;

    public DelayedTravelToEvent(Point2D destination, INavigableVessel vessel, Optional<ICity> city) {
        this.destination = destination;
        this.vessel = vessel;
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public Point2D getDestination() {
        return this.destination;
    }

    public INavigableVessel getVessel() {
        return this.vessel;
    }

    public Optional<ICity> getCity() {
        return this.city;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelayedTravelToEvent)) {
            return false;
        }
        DelayedTravelToEvent other = (DelayedTravelToEvent)o;
        Point2D this$destination = this.getDestination();
        Point2D other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        INavigableVessel this$vessel = this.getVessel();
        INavigableVessel other$vessel = other.getVessel();
        if (this$vessel == null ? other$vessel != null : !this$vessel.equals(other$vessel)) {
            return false;
        }
        Optional<ICity> this$city = this.getCity();
        Optional<ICity> other$city = other.getCity();
        if (this$city == null ? other$city != null : !((Object)this$city).equals(other$city)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Point2D $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        INavigableVessel $vessel = this.getVessel();
        result = result * 59 + ($vessel == null ? 43 : $vessel.hashCode());
        Optional<ICity> $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        return result;
    }

    public String toString() {
        return "DelayedTravelToEvent(destination=" + this.getDestination() + ", vessel=" + this.getVessel() + ", city=" + this.getCity() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ")";
    }
}

