/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.event.data.CourierPatrolStateInternal;
import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.display.event.handler.impl.AttackListener;
import ch.sahits.game.openpatrician.display.event.handler.impl.DeliverPackages;
import ch.sahits.game.openpatrician.display.event.handler.impl.NextCourierPatrolStation;
import ch.sahits.game.openpatrician.display.event.handler.impl.NextPatrolStation;
import ch.sahits.game.openpatrician.display.event.handler.impl.PassengerLeavesShipOnArrival;
import ch.sahits.game.openpatrician.display.event.handler.impl.ShipArrivalForLoading;
import ch.sahits.game.openpatrician.display.event.handler.impl.SinkConcurrentsShipOrder;
import ch.sahits.game.openpatrician.display.event.handler.impl.UnloadOnArrival;
import ch.sahits.game.openpatrician.display.event.handler.impl.ViewChangeActionRunnable;
import ch.sahits.game.openpatrician.display.event.handler.impl.ViewChangeDialogStateRunnable;
import ch.sahits.game.openpatrician.display.event.handler.impl.ViewChangeDialogTemplateRunnable;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class EventHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(EventHandlerFactory.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TextSizingUtility sizeing;

    public DeliverPackages getDeliverPackagesHandler(ICity city, IShip ship, LocalDateTime deadline, int premium, int amount) {
        Object[] args = new Object[]{city, ship, deadline, premium, amount};
        return (DeliverPackages)((Object)this.context.getBean("deliverPackages", args));
    }

    public ShipArrivalForLoading getShipArrivalForLoadingHandler(ICity city, IPlayer player, LocalDateTime deadline, int requiredAmount, int premium) {
        Object[] args = new Object[]{city, player, deadline, requiredAmount, premium};
        return (ShipArrivalForLoading)((Object)this.context.getBean("shipArrivalForLoading", args));
    }

    public PassengerLeavesShipOnArrival getPassengerLeavingOnShipArrivalHandler(IShip ship, ICity city, IPlayer shipsOwner, LocalDateTime deadline, EDialogTemplateType dialogType, DialogTemplateParameterSupplier dialogParameterSupplier, LinearDeadlinePremiumCalculator premiumCalculator) {
        Object[] args = new Object[]{ship, city, shipsOwner, deadline, dialogType, dialogParameterSupplier, premiumCalculator};
        return (PassengerLeavesShipOnArrival)((Object)this.context.getBean("passengerLeavesShipOnArrival", args));
    }

    public UnloadOnArrival getUnloadOnArrivalHandler(IShip ship, ICity city, int loadedAmount) {
        return (UnloadOnArrival)((Object)this.context.getBean("unloadOnArrival", new Object[]{ship, city, loadedAmount}));
    }

    public NextCourierPatrolStation getNextCourierPatrolStationHanlder(IShip ship, ICity city, CourierPatrolStateInternal state, IPlayer player, LocalDateTime deadline) {
        Object[] args = new Object[]{ship, city, state, player, deadline};
        return (NextCourierPatrolStation)((Object)this.context.getBean("nextCourierPatrolStation", args));
    }

    public ViewChangeActionRunnable getViewChangeActionRunnable(EDialogType selected) {
        Object[] args = new Object[]{selected};
        return (ViewChangeActionRunnable)this.context.getBean("viewChangeActionRunnable", args);
    }

    public ViewChangeDialogTemplateRunnable getViewChangeActionRunnable(DialogTemplate template) {
        Object[] args = new Object[]{template};
        return (ViewChangeDialogTemplateRunnable)this.context.getBean("viewChangeDialogTemplateRunnable", args);
    }

    public Runnable getViewChangeActionRunnable(IDialogState state) {
        Object[] args = new Object[]{state};
        return (ViewChangeDialogStateRunnable)this.context.getBean("viewChangeDialogStateRunnable", args);
    }

    public IAttackListener getAttackListener(IShip ship, PatrolInternalState state) {
        Object[] args = new Object[]{ship, state};
        return (AttackListener)this.context.getBean("attackListener", args);
    }

    public NextPatrolStation getNextPatrolStation(INavigableVessel ship, ICity city, PatrolInternalState state, IPlayer player, LocalDateTime deadline, IAttackListener atackListener) {
        Object[] args = new Object[]{ship, city, state, player, deadline, atackListener};
        log.info("Retrieve next patrol station for {}", (Object)state);
        return (NextPatrolStation)((Object)this.context.getBean("nextPatrolStation", args));
    }

    public SinkConcurrentsShipOrder getSinkConcurrentsShipOrder(IPlayer opponent, IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        Object[] args = new Object[]{opponent, player, offerdTime, premium, reconciliation};
        return (SinkConcurrentsShipOrder)((Object)this.context.getBean("sinkConcurrentsShipOrder", args));
    }
}

