/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class UnloadOnArrival
extends ShipEntersPortEventListener {
    private final int amountLoaded;

    public UnloadOnArrival(IShip ship, ICity city, int loaded) {
        super((INavigableVessel)ship, city);
        this.amountLoaded = loaded;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public boolean execute(ICity city) {
        ((IShip)this.getShip()).setOccupiedSpace(((IShip)this.getShip()).getOccupiedSpace() - this.amountLoaded);
        return true;
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
    }
}

