/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.event.BuyWares;
import ch.sahits.game.openpatrician.clientserverinterface.event.PostponedDisplayDialogMessage;
import ch.sahits.game.openpatrician.clientserverinterface.event.PostponedDisplayMessage;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerTaskFactory;
import ch.sahits.game.openpatrician.display.event.task.BreakInAction;
import ch.sahits.game.openpatrician.display.event.task.ChurchFeedingReputationUpdateTimedTask;
import ch.sahits.game.openpatrician.display.event.task.ConcurrentReconciliation;
import ch.sahits.game.openpatrician.display.event.task.DelayedCaughtAction;
import ch.sahits.game.openpatrician.display.event.task.FinedTimedTask;
import ch.sahits.game.openpatrician.display.event.task.FreePirateTimedTask;
import ch.sahits.game.openpatrician.display.event.task.IBreakInAction;
import ch.sahits.game.openpatrician.display.event.task.IDelayedCaughtAction;
import ch.sahits.game.openpatrician.display.event.task.MarriageFeastDeliveryTask;
import ch.sahits.game.openpatrician.display.event.task.MarriageOfferTimedTask;
import ch.sahits.game.openpatrician.display.event.task.OpponentsOrder;
import ch.sahits.game.openpatrician.display.event.task.TravelToTimedTask;
import ch.sahits.game.openpatrician.display.event.task.WarehouseTenantPayTimedTask;
import ch.sahits.game.openpatrician.display.event.task.WarehouseTentantLeaveTimedTask;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.people.impl.BuyerState;
import ch.sahits.game.openpatrician.model.people.impl.WarehouseTenant;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;
import java.util.Optional;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ClientTaskFactory
extends ClientServerTaskFactory {
    @Autowired
    private ApplicationContext context;

    public OpponentsOrder getOpponentsOrder(IPlayer opponent, IPlayer client, IPlayer player, int premium) {
        Object[] args = new Object[]{opponent, client, player, premium};
        return (OpponentsOrder)((Object)this.context.getBean("opponentsOrder", args));
    }

    public TimedTask getConcurrentReconciliation() {
        return (TimedTask)this.context.getBean(ConcurrentReconciliation.class);
    }

    public TimedTask getBuyWares(ICityPlayerProxyJFX cityPlayerProxy, IBuyer buyer) {
        Object[] args = new Object[]{cityPlayerProxy.getPlayer(), cityPlayerProxy.getCity(), new BuyerState(buyer)};
        return (BuyWares)this.context.getBean("buyWares", args);
    }

    public IDelayedCaughtAction getDelayedCaughtAction(IPlayer player, ICity where) {
        Object[] args = new Object[]{player, where};
        return (DelayedCaughtAction)this.context.getBean("delayedCaughtAction", args);
    }

    public IBreakInAction getBreakInAction(IPlayer opponent) {
        Object[] args = new Object[]{opponent};
        return (BreakInAction)this.context.getBean("breakInAction", args);
    }

    public PostponedDisplayMessage getPostponedDisplayMessage(LocalDateTime executionTime, EMessageCategory category, String messageKey, Object ... messageArgs) {
        return (PostponedDisplayMessage)this.context.getBean(PostponedDisplayMessage.class, new Object[]{executionTime, category, messageKey, messageArgs});
    }

    public PostponedDisplayDialogMessage getPostponedDisplayDialogMessage(LocalDateTime executionTime, EMessageCategory category, DialogTemplate template) {
        Object[] args = new Object[]{executionTime, category, template};
        return (PostponedDisplayDialogMessage)this.context.getBean("postponedDisplayDialogMessage", args);
    }

    public FinedTimedTask getFinedTask(IHumanPlayer player, int fine, String messageKey, LocalDateTime deadline) {
        return (FinedTimedTask)((Object)this.context.getBean("finedTimedTask", new Object[]{player, fine, messageKey, deadline}));
    }

    public MarriageOfferTimedTask getMarriageOfferTask(IHumanPlayer player, MarriageBrokerAnnouncementState state, LocalDateTime deadLine) {
        return (MarriageOfferTimedTask)((Object)this.context.getBean("marriageOfferTimedTask", new Object[]{player, state, deadLine}));
    }

    public TravelToTimedTask getTravelToDelayed(Point2D destination, INavigableVessel vessel, Optional<ICity> city) {
        return (TravelToTimedTask)((Object)this.context.getBean("travelToTimedTask", new Object[]{destination, vessel, city}));
    }

    public WarehouseTenantPayTimedTask getWarehouseTenantPayment(IPlayer player, IWarehouseTenant tenant, LocalDateTime deadLine) {
        return (WarehouseTenantPayTimedTask)((Object)this.context.getBean("warehouseTenantPayTimedTask", new Object[]{player, new WarehouseTenant(tenant), deadLine}));
    }

    public WarehouseTentantLeaveTimedTask getWarehouseTenantLeaving(ITradingOffice office, IWarehouseTenant tenant, LocalDateTime dealine) {
        return (WarehouseTentantLeaveTimedTask)((Object)this.context.getBean("warehouseTentantLeaveTimedTask", new Object[]{office, new WarehouseTenant(tenant), dealine}));
    }

    public FreePirateTimedTask getFreePirateTask(INonFreeSeaPirate seaPirate, LocalDateTime deadline) {
        return (FreePirateTimedTask)((Object)this.context.getBean("freePirateTimedTask", new Object[]{seaPirate, deadline}));
    }

    public ChurchFeedingReputationUpdateTimedTask getReputationUpdateTaskChurchFeeding(ICity city, IPlayer player, int amountBeggers, LocalDateTime deadline) {
        return (ChurchFeedingReputationUpdateTimedTask)((Object)this.context.getBean("churchFeedingReputationUpdateTimedTask", new Object[]{city, player, amountBeggers, deadline}));
    }

    public MarriageFeastDeliveryTask getMarriageFeastDelivery(LocalDateTime deadline, IPlayer player, ICity city) {
        return (MarriageFeastDeliveryTask)((Object)this.context.getBean(MarriageFeastDeliveryTask.class, new Object[]{deadline, player, city}));
    }
}

