/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.service.CelebrationService;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageFeastDeliveryTask
extends TimedTask {
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private CelebrationService celebrationService;
    private IPlayer player;
    private ICity city;

    public MarriageFeastDeliveryTask(LocalDateTime deadLine, IPlayer player, ICity city) {
        this.player = player;
        this.city = city;
        this.setExecutionTime(deadLine);
    }

    public void run() {
        Map nbGuests = this.celebrationService.calculateAttendees(this.city);
        Map requiredAmount = this.celebrationService.calculateRequiredAmounts(nbGuests);
        ITradingOffice office = (ITradingOffice)this.player.findTradingOffice(this.city).get();
        HashMap<IWare, Integer> removedAmount = new HashMap<IWare, Integer>();
        HashMap prices = new HashMap();
        requiredAmount.entrySet().stream().forEach(entry -> {
            int availableAmount = office.getWare((IWare)entry.getKey()).getAmount();
            prices.put((IWare)entry.getKey(), office.getWare((IWare)entry.getKey()).getAVGPrice());
            office.move((IWare)entry.getKey(), -availableAmount, 0);
            removedAmount.put((IWare)entry.getKey(), availableAmount);
        });
        int sum = 0;
        for (IWare ware : removedAmount.keySet()) {
            int price = (Integer)prices.get(ware);
            sum += price * (Integer)removedAmount.get(ware);
        }
        double bonusFactor = this.wereWaresMissing(requiredAmount, removedAmount) ? 1.0 : (this.wereWaresExact(requiredAmount, removedAmount) ? 1.1 : 1.15);
        long payout = Math.round((double)sum * bonusFactor);
        this.player.getCompany().updateCashDirectly(payout);
        if (bonusFactor > 1.0) {
            this.city.getReputation(this.player).update(200);
        }
        if (this.player instanceof IHumanPlayer) {
            String messageKey = bonusFactor > 1.0 ? "ch.sahits.game.openpatrician.display.event.task.MarriageFeastDeliveryTask.success" : "ch.sahits.game.openpatrician.display.event.task.MarriageFeastDeliveryTask.flop";
            DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.event.task.MarriageFeastDeliveryTask.title").messageKey(messageKey).messageArgs(new Object[]{payout}).build();
            DisplayTemplateMessage message = new DisplayTemplateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.display.event.task.MarriageFeastDeliveryTask.title", template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)this.player, (Object)message);
            this.clientEventBus.post((Object)tagetDisplayMsg);
        }
    }

    private boolean wereWaresMissing(Map<IWare, Integer> requiredAmount, Map<IWare, Integer> removedAmount) {
        for (IWare ware : requiredAmount.keySet()) {
            if (requiredAmount.get(ware) <= removedAmount.get(ware)) continue;
            return true;
        }
        return false;
    }

    private boolean wereWaresExact(Map<IWare, Integer> requiredAmount, Map<IWare, Integer> removedAmount) {
        for (IWare ware : requiredAmount.keySet()) {
            if (requiredAmount.get(ware) == removedAmount.get(ware)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MarriageFeastDeliveryTask{, execution at " + this.getExecutionTime() + ", player=" + this.player.getUuid() + " " + this.player.getName() + " " + this.player.getLastName() + ", city=" + this.city + "}";
    }
}

