/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WarehouseTentantLeaveTimedTask
extends TimedTask {
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    private ITradingOffice office;
    private IWarehouseTenant tenant;

    public WarehouseTentantLeaveTimedTask(ITradingOffice office, IWarehouseTenant tenant, LocalDateTime dealine) {
        this.office = office;
        this.tenant = tenant;
        this.setExecutionTime(dealine);
    }

    public void run() {
        this.clientEventBus.post((Object)new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.dialog.TavernWarehouseTenantDialog.acceptMessage", new Object[0]));
        this.office.setOccupiedSpace(this.office.getOccupiedSpace() - this.tenant.getAmount());
    }

    public String toString() {
        IPlayer player = this.office.getOwner();
        return "WarehouseTentantLeaveTimedTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + player.getUuid() + " " + player.getName() + " " + player.getLastName() + ", tenant=" + this.tenant.getName() + "}";
    }
}

