/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class Ship2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;
    @Autowired
    private TradeService tradeService;

    public Ship2CityJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel vessel = this.transfer.getVessel();
        int amountOnShip = vessel.getWare(this.ware).getAmount();
        if (amountOnShip > 0) {
            ICity city = this.transfer.getCity();
            int amount2Move = this.transfer.getAmount(amountOnShip);
            this.tradeService.sellWareShipToCity(vessel, this.transfer.getPlayer(), city, this.ware, amount2Move, Optional.empty());
        }
    }
}

