/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.control;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.EViewState;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NavigationStateChange;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.MapUpdateCityAdd;
import ch.sahits.game.openpatrician.event.data.NewGameClient;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipLeavingPort;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ui.MapState;
import ch.sahits.game.openpatrician.utilities.IRebinabable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MiniMap
extends Group
implements IRebinabable {
    private static final Logger log = LoggerFactory.getLogger(MiniMap.class);
    @Autowired
    private IMap map;
    @Autowired
    private IImageUtilities imageUtilities;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private MapState mapState;
    private ImageView imgView;
    private boolean navigationDisabled = false;
    private IDialogContoller dialogContoller;
    private Pane mapPane;
    private double scale;

    @PostConstruct
    private void initializeControl() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        this.setManaged(false);
        this.mapPane = new Pane();
        this.imgView = new ImageView();
        this.imgView.setFitWidth(236.0);
        this.imgView.setFitHeight(192.0);
        this.imgView.setPreserveRatio(false);
        this.mapPane.getChildren().addAll((Object[])new Node[]{this.imgView});
        this.getChildren().add((Object)this.mapPane);
        this.addEventHandlers();
    }

    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    private void addEventHandlers() {
        this.setOnMouseReleased(event -> {
            if (!this.navigationDisabled) {
                if (this.viewState.getState() == EViewState.MAP) {
                    log.info("Switch back to port scene");
                    this.mapState.setShowingLargeSeaMap(false);
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                } else if (this.mapState.isMiniMapShowingSea()) {
                    log.info("Switch to big sea map");
                    this.mapState.setShowingLargeSeaMap(true);
                    this.dialogContoller.closeDialog();
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_SEA_MAP);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                    proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                } else {
                    log.warn("Cannot switch from town view to sea map");
                }
            }
        });
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        IHumanPlayer player = newGameDTO.getPlayer();
        this.initializeMapImage((IPlayer)player);
    }

    public void initializeMapImage(IPlayer player) {
        Image mapImage = this.imageUtilities.createMapWithCities(this.map, player);
        Dimension2D dim = this.map.getDimension();
        this.scale = 192.0 / dim.getHeight();
        double widthOrigImg = 236.0 / this.scale;
        double xlocation = player.getHometown().getCoordinates().getX();
        double x = Math.max(0.0, xlocation - widthOrigImg / 2.0);
        Rectangle2D viewport = new Rectangle2D(x, 0.0, widthOrigImg, dim.getHeight());
        Image transferableMap = mapImage;
        Platform.runLater(() -> {
            this.imgView.setViewport(viewport);
            this.imgView.setImage(transferableMap);
            for (ICity city : this.map.getCities()) {
                List ships;
                if (!(city.getCoordinates().getX() >= x) || !(city.getCoordinates().getX() <= x + widthOrigImg) || (ships = player.findShips(city)).isEmpty()) continue;
                this.drawShipPresenceInCity(city, x);
            }
        });
    }

    private void drawShipPresenceInCity(ICity city, double offset) {
        int radius = 8;
        int cityX = (int)Math.rint(city.getCoordinates().getX());
        int cityY = (int)Math.rint(city.getCoordinates().getY());
        Circle c = new Circle(((double)cityX - offset) * this.scale, (double)cityY * this.scale, (double)radius * this.scale, (Paint)Color.WHITE);
        c.setId(city.getUniqueID());
        this.mapPane.getChildren().add((Object)c);
    }

    @Subscribe
    public void handleMapChange(MapUpdateCityAdd event) {
        this.initializeMapImage(event.getPlayer());
    }

    @Subscribe
    public void handleShipLeavesCity(ShipLeavingPort event) {
        Optional<Node> optPresence;
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).isEmpty() && (optPresence = this.findCityCircle(city)).isPresent()) {
            Platform.runLater(() -> this.mapPane.getChildren().remove(optPresence.get()));
        }
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).size() == 1) {
            Dimension2D dim = this.map.getDimension();
            this.scale = 192.0 / dim.getHeight();
            double viewportOffset = this.imgView.getViewport().getMinX();
            Platform.runLater(() -> this.drawShipPresenceInCity(city, viewportOffset));
        }
    }

    private Optional<Node> findCityCircle(ICity city) {
        return this.mapPane.getChildren().stream().filter(node -> node instanceof Circle && node.getId().equals(city.getUniqueID())).findFirst();
    }

    @Subscribe
    public void handleNavigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.navigationDisabled = true;
                break;
            }
            case ENABLE_NAVIGATION: {
                this.navigationDisabled = false;
                break;
            }
            default: {
                log.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    public void rebind() {
        Iterator iterator = this.mapPane.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Circle)) continue;
            iterator.remove();
        }
    }
}

