/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.model;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BarrelConfiguration {
    @Autowired
    private IDataImageLoader imageLoader;
    private int iconSize = 64;
    private int barrelTop = 4;
    private int barrelBottom = 63;
    private int totalHeigh;

    @PostConstruct
    private void init() {
        double scaleFactor = (double)this.iconSize / 64.0;
        this.barrelTop = (int)((double)this.barrelTop * scaleFactor);
        this.barrelBottom = (int)((double)this.barrelBottom * scaleFactor);
        this.totalHeigh = this.barrelBottom - this.barrelTop;
    }

    public ImageView getBarrelView() {
        Image img = this.imageLoader.getImage("icons/" + this.iconSize + "/barrel");
        ImageView barrel = new ImageView(img);
        barrel.setId("barrelImage");
        return barrel;
    }

    public Path createBarrelShape() {
        Path path = new Path();
        double scaleFrom128 = 1.0;
        if (this.iconSize == 64) {
            scaleFrom128 = 0.5;
        }
        MoveTo start = new MoveTo(19.0 * scaleFrom128, 13.0 * scaleFrom128);
        path.getElements().add((Object)start);
        ArcTo arcToTop = new ArcTo();
        arcToTop.setX(104.0 * scaleFrom128);
        arcToTop.setY(13.0 * scaleFrom128);
        arcToTop.setRadiusX(42.5 * scaleFrom128);
        arcToTop.setRadiusY(-5.0 * scaleFrom128);
        arcToTop.setSweepFlag(true);
        path.getElements().add((Object)arcToTop);
        CubicCurveTo cubicToRight = new CubicCurveTo();
        cubicToRight.setX(61.5 * scaleFrom128);
        cubicToRight.setY(126.0 * scaleFrom128);
        double c1x = 115.0 * scaleFrom128;
        double c1y = 57.0 * scaleFrom128;
        double c2x = 109.0 * scaleFrom128;
        double c2y = 126.0 * scaleFrom128;
        cubicToRight.setControlX1(c1x);
        cubicToRight.setControlY1(c1y);
        cubicToRight.setControlX2(c2x);
        cubicToRight.setControlY2(c2y);
        path.getElements().add((Object)cubicToRight);
        CubicCurveTo cubicToLeft = new CubicCurveTo();
        cubicToLeft.setX(start.getX());
        cubicToLeft.setY(start.getY());
        cubicToLeft.xProperty().bind((ObservableValue)start.xProperty());
        cubicToLeft.yProperty().bind((ObservableValue)start.yProperty());
        cubicToLeft.setControlX1(26.0 * scaleFrom128);
        cubicToLeft.setControlY1(c2y);
        cubicToLeft.setControlX2(8.0 * scaleFrom128);
        cubicToLeft.setControlY2(c1y);
        path.getElements().add((Object)cubicToLeft);
        path.setFill((Paint)new Color(0.0, 0.0, 0.0, 0.0));
        return path;
    }

    public Rectangle getUnloadableShape(IShip ship) {
        double y = this.getUnloadableTop(ship);
        double height = this.getHeight(this.getUnloadablePercentage(ship));
        Rectangle rect = new Rectangle(0.0, y, (double)this.iconSize, height);
        rect.setId("unloadableRect");
        rect.setFill((Paint)Color.BLUE);
        return rect;
    }

    public Rectangle getCargoShape(IShip ship) {
        double y = this.getCargoTop(ship);
        double height = this.getHeight(this.getCargoPercentage(ship));
        Rectangle rect = new Rectangle(0.0, y, (double)this.iconSize, height);
        rect.setId("cargoRect");
        rect.setFill((Paint)Color.BLUE);
        return rect;
    }

    private double getUnloadablePercentage(IShip ship) {
        double loadedCargoAmount = ship.getLoadBinding().get();
        double totalLoaded = ship.getLoadableSpace() - ship.getCapacity();
        double loadedWeaponsPassengerEtc = totalLoaded - loadedCargoAmount;
        return loadedWeaponsPassengerEtc / (double)ship.getLoadableSpace();
    }

    private double getUnloadableTop(IShip ship) {
        double height = this.getHeight(this.getUnloadablePercentage(ship));
        return (double)this.barrelBottom - height;
    }

    private double getCargoPercentage(IShip ship) {
        double loadedCargoAmount = ship.getLoadBinding().get();
        return loadedCargoAmount / (double)ship.getLoadableSpace();
    }

    private double getCargoTop(IShip ship) {
        double height = this.getHeight(this.getCargoPercentage(ship));
        return this.getUnloadableTop(ship) - height;
    }

    private double getHeight(double heighPercentage) {
        return heighPercentage * (double)this.totalHeigh;
    }
}

