/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.GenericTriple;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ISingleSelectableCheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.KeyCode;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CreateShipCheat
implements ISingleSelectableCheatCommand {
    private static final Logger log = LoggerFactory.getLogger(CreateShipCheat.class);
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.S;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.CreateShipCheat.desc";
    @ListType(value=GenericTriple.class)
    private final List<GenericTriple<String>> options = new ArrayList<GenericTriple<String>>();
    private GenericTriple<String> selectedOption;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    @PostConstruct
    private void init() {
        for (EShipType shipType : EShipType.values()) {
            String display = this.messageSource.getMessage(shipType.name(), new Object[0], this.locale.getCurrentLocal());
            this.options.add((GenericTriple<String>)new GenericTriple((Object)String.valueOf(shipType.ordinal()), (Object)shipType.name(), (Object)display));
        }
        this.selectedOption = this.options.get(0);
    }

    public void execute() {
        ISnaikka ship;
        ClientViewState viewState = (ClientViewState)this.context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        ICity city = viewState.getCurrentCityProxy().get().getCity();
        ShipFactory shipFactory = (ShipFactory)this.context.getBean(ShipFactory.class);
        EShipType shipType = EShipType.valueOf((String)((String)this.selectedOption.getSecond()));
        switch (shipType) {
            case SNAIKKA: {
                ship = shipFactory.createSnaikka("Cheat ship name", EShipUpgrade.LEVEL1, 250);
                break;
            }
            case CRAYER: {
                ship = shipFactory.createCrayer("Cheat ship name", EShipUpgrade.LEVEL1, 350);
                break;
            }
            case COG: {
                ship = shipFactory.createCog("Cheat ship name", EShipUpgrade.LEVEL1, 550);
                break;
            }
            case HOLK: {
                ship = shipFactory.createHolk("Cheat ship name", EShipUpgrade.LEVEL1, 700);
                break;
            }
            default: {
                ship = null;
            }
        }
        ship.setOwner((IShipOwner)player);
        player.addShip((IShip)ship);
        player.addSelectableVessel((INavigableVessel)ship);
        ship.setLocation(city.getCoordinates());
        viewState.getCurrentCityProxy().get().arrive((INavigableVessel)ship);
        log.debug("Cheat created a new ship in " + city.getName());
    }

    public KeyCode getControlKey() {
        return this.controlKey;
    }

    public KeyCode getKey() {
        return this.key;
    }

    public String getDescriptionTextKey() {
        return this.descriptionTextKey;
    }

    public List<GenericTriple<String>> getOptions() {
        return this.options;
    }

    public GenericTriple<String> getSelectedOption() {
        return this.selectedOption;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setSelectedOption(GenericTriple<String> selectedOption) {
        this.selectedOption = selectedOption;
    }
}

