/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.notice;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.dialog.ship.ShipModelForShipList;
import ch.sahits.game.openpatrician.display.model.BarrelConfiguration;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.BaleIconView;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.control.CoinIconView;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardContentProvider {
    @Autowired
    private IDataImageLoader imageLoader;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private ModelTranslations translations;
    @Autowired
    private Date date;
    @Autowired
    private BarrelConfiguration barrelConfiguration;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ShipService shipService;
    private Path barrelShape;

    @PostConstruct
    private void init() {
        this.barrelShape = this.barrelConfiguration.createBarrelShape();
    }

    public Region createHeader(ENoticeBoardType type, ViewChangeCityPlayerProxyJFX proxy) {
        switch (type) {
            case SHIP_WARE_INFO: {
                return this.createShipWareInfoHeader(proxy);
            }
        }
        throw new IllegalStateException("For " + type + " no header is defined");
    }

    public Region createContent(ENoticeBoardType type, ViewChangeCityPlayerProxyJFX proxy) {
        switch (type) {
            case SHIP_WARE_INFO: {
                return this.createShipWareInfoContent(proxy);
            }
        }
        throw new IllegalStateException("For " + type + " no content is defined");
    }

    public ObservableValue<?> createObservable(ENoticeBoardType type, ViewChangeCityPlayerProxyJFX proxy) {
        switch (type) {
            case SHIP_WARE_INFO: {
                return this.shipWareObservable(proxy);
            }
        }
        throw new IllegalStateException("For " + type + " no observable is defined");
    }

    private Region createShipWareInfoHeader(ViewChangeCityPlayerProxyJFX proxy) {
        IShip ship;
        Image img;
        ImageView icon;
        INavigableVessel vessel = proxy.getActiveShip();
        VBox headerLeft = new VBox();
        FlowPane firstLine = new FlowPane();
        if (vessel.getAutotrading().isPresent()) {
            Image autotrade = this.imageLoader.getImage("icons/32/icon_autotrade");
            icon = new ImageView(autotrade);
            icon.setId("autotrade");
            firstLine.getChildren().add((Object)icon);
        }
        if (vessel instanceof IShip) {
            img = this.imageLoader.getImage("icons/32/sailing-icon");
            icon = new ImageView(img);
            icon.setId("singleShip");
            firstLine.getChildren().add((Object)icon);
            ship = (IShip)vessel;
        } else {
            img = this.imageLoader.getImage("icons/32/icon_convoy");
            icon = new ImageView(img);
            icon.setId("convoy");
            firstLine.getChildren().add((Object)icon);
            ship = ((IConvoy)vessel).getOrlegShip();
        }
        EShipTravelState travelState = (EShipTravelState)ship.travelState().get();
        Label shipName = new Label(vessel.getName());
        shipName.setId("shipName");
        shipName.getStyleClass().add((Object)"noticeBoardText");
        firstLine.getChildren().add((Object)shipName);
        headerLeft.getChildren().add((Object)firstLine);
        FlowPane secondLine = new FlowPane();
        switch (travelState) {
            case TRAVEL_TO_CITY: 
            case TRAVEL_TO_DESTINATION: {
                int duration = this.shipService.calculateDaysTillArrival((INavigableVessel)ship);
                String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardContentProvider.remainingTravelDuration", new Object[]{duration}, this.locale.getCurrentLocal());
                Label remaining = new Label(s);
                remaining.setId("remaining");
                remaining.getStyleClass().add((Object)"noticeBoardText");
                secondLine.getChildren().add((Object)remaining);
            }
        }
        ImageView statusIcon = new ImageView(this.dialogUtil.getStatusIcon(travelState));
        statusIcon.setId("statusIcon");
        secondLine.getChildren().add((Object)statusIcon);
        ShipModelForShipList model = (ShipModelForShipList)this.context.getBean(ShipModelForShipList.class, new Object[]{ship});
        StringBinding destinationBinding = model.destination();
        String s = destinationBinding.get();
        Label destination = new Label(s);
        destination.setId("destination");
        destination.getStyleClass().add((Object)"noticeBoardText");
        destination.textProperty().bind((ObservableValue)destinationBinding);
        secondLine.getChildren().add((Object)destination);
        headerLeft.getChildren().add((Object)secondLine);
        headerLeft.getChildren().add((Object)this.dialogUtil.createShipInfoOnThreeLines((ObjectProperty<IShip>)new SimpleObjectProperty((Object)ship), false, 200));
        Pane headerRight = new Pane();
        ImageView barrel = this.barrelConfiguration.getBarrelView();
        headerRight.getChildren().add((Object)barrel);
        int barrelBottom = 63;
        int cargoCapacity = vessel.getCapacity();
        double size = vessel.getLoadableSpace();
        int loadedWares = vessel.getLoadBinding().get();
        double unloadable = size - (double)loadedWares - (double)cargoCapacity;
        Shape unloadableShape = null;
        if (unloadable > 0.0) {
            Rectangle unloadableRect = this.barrelConfiguration.getUnloadableShape(ship);
            unloadableShape = Shape.intersect((Shape)unloadableRect, (Shape)this.barrelShape);
            unloadableShape.setFill((Paint)new Color(0.0, 0.0, 1.0, 0.65));
            unloadableShape.setId("unloadableShape");
            headerRight.getChildren().add((Object)unloadableShape);
            Label weaponSpace = new Label(String.valueOf((int)unloadable));
            weaponSpace.setId("weaponSpace");
            weaponSpace.getStyleClass().add((Object)"noticeBoardText");
            weaponSpace.setLayoutX(55.0);
            weaponSpace.setLayoutY(58.0);
            headerRight.getChildren().add((Object)weaponSpace);
        }
        if (loadedWares > 0) {
            Rectangle waresRect = this.barrelConfiguration.getCargoShape(ship);
            Shape intersect = Shape.intersect((Shape)waresRect, (Shape)this.barrelShape);
            Shape wareShape = unloadableShape != null ? Shape.subtract((Shape)intersect, (Shape)unloadableShape) : intersect;
            wareShape.setFill((Paint)new Color(0.0, 0.39062, 0.0, 0.65));
            wareShape.setId("wareShape");
            headerRight.getChildren().add((Object)wareShape);
            Label wareSpace = new Label(String.valueOf(loadedWares));
            wareSpace.setId("wareSpace");
            wareSpace.getStyleClass().add((Object)"noticeBoardText");
            wareSpace.setLayoutX(55.0);
            wareSpace.setLayoutY((double)(barrelBottom / 2));
            headerRight.getChildren().add((Object)wareSpace);
        }
        Label totalCapacity = new Label(String.valueOf((int)size));
        totalCapacity.setId("totalCargoCapacity");
        totalCapacity.getStyleClass().add((Object)"noticeBoardText");
        totalCapacity.setLayoutX(55.0);
        headerRight.getChildren().add((Object)totalCapacity);
        headerRight.setMaxWidth(75.0);
        headerRight.setMinWidth(75.0);
        headerRight.setLayoutX(141.0);
        Pane header = new Pane(new Node[]{headerLeft, headerRight});
        header.setId("header");
        header.setMaxWidth(216.0);
        header.setMinWidth(216.0);
        return header;
    }

    private Region createShipWareInfoContent(ViewChangeCityPlayerProxyJFX proxy) {
        GridPane content = new GridPane();
        content.setId("shipWareInfo");
        INavigableVessel vessel = proxy.getActiveShip();
        int row = 0;
        for (IWare ware : vessel.getLoadedWares()) {
            AmountablePrice amountable = vessel.getWare(ware);
            int amount = amountable.getAmount();
            if (amount <= 0) continue;
            int avgValue = amountable.getAVGPrice();
            String wareName = this.translations.getLocalDisplayName(ware);
            Label amountLbl = new Label(String.valueOf(amount));
            amountLbl.setId("amount" + row);
            amountLbl.getStyleClass().add((Object)"noticeBoardText");
            content.add((Node)amountLbl, 0, row);
            GridPane.setHalignment((Node)amountLbl, (HPos)HPos.RIGHT);
            if (ware.isBarrelSizedWare()) {
                BarrelIconView barrel = new BarrelIconView();
                barrel.setId("barrelIcon" + row);
                content.add((Node)barrel, 1, row);
                GridPane.setHalignment((Node)barrel, (HPos)HPos.LEFT);
            } else {
                BaleIconView bale = new BaleIconView();
                bale.setId("baleIcon" + row);
                content.add((Node)bale, 1, row);
                GridPane.setHalignment((Node)bale, (HPos)HPos.LEFT);
            }
            Label wareNameLbl = new Label(wareName);
            wareNameLbl.setId("wareName" + row);
            wareNameLbl.getStyleClass().add((Object)"noticeBoardText");
            content.add((Node)wareNameLbl, 2, row);
            GridPane.setHalignment((Node)wareNameLbl, (HPos)HPos.LEFT);
            Label priceLbl = new Label(String.valueOf(avgValue));
            priceLbl.setId("price" + row);
            priceLbl.getStyleClass().add((Object)"noticeBoardText");
            content.add((Node)priceLbl, 3, row);
            GridPane.setHalignment((Node)priceLbl, (HPos)HPos.RIGHT);
            CoinIconView coin = new CoinIconView();
            coin.setId("coinIcon" + row);
            content.add((Node)coin, 4, row);
            GridPane.setHalignment((Node)coin, (HPos)HPos.LEFT);
            content.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(40.0), new ColumnConstraints(32.0), new ColumnConstraints(60.0), new ColumnConstraints(40.0), new ColumnConstraints(32.0)});
            ++row;
        }
        if (vessel instanceof IShip && ((IShip)vessel).getPassenger().isPresent() || vessel instanceof IConvoy && ((IConvoy)vessel).getOrlegShip().getPassenger().isPresent()) {
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardContentProvider.passenger", new Object[0], this.locale.getCurrentLocal());
            Label passengerLbl = new Label(s);
            passengerLbl.setId("passengerLabel");
            passengerLbl.getStyleClass().add((Object)"noticeBoardText");
            content.add((Node)passengerLbl, 0, row, 5, 1);
        }
        return content;
    }

    private ObservableValue<Boolean> shipWareObservable(final ViewChangeCityPlayerProxyJFX proxy) {
        return new BooleanBinding(){
            private boolean value;
            {
                super.bind(new Observable[]{proxy.activeShipProperty()});
                INavigableVessel activeShip = proxy.getActiveShip();
                super.bind(new Observable[]{activeShip.getLoadBinding()});
                if (activeShip instanceof IShip) {
                    super.bind(new Observable[]{((IShip)activeShip).travelState()});
                } else {
                    super.bind(new Observable[]{((IConvoy)activeShip).getOrlegShip().travelState()});
                }
                super.bind(new Observable[]{NoticeBoardContentProvider.this.date.dayDateBinding()});
                this.value = true;
            }

            protected boolean computeValue() {
                this.value = !this.value;
                return this.value;
            }
        };
    }
}

