/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.notice;

import ch.sahits.game.event.data.ClockTickPostDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.notice.NoticeBoardContentProvider;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NavigationStateChange;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.NoticeBoardPersistentClose;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OpenPatricianNoticeBoard
extends NoticeBoard {
    private static final Logger log = LoggerFactory.getLogger(OpenPatricianNoticeBoard.class);
    private ICityPlayerProxyJFX lastProxy;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private NoticeBoardContentProvider contentProvider;
    private ObservableValue<?> contentUpdate = null;
    private ChangeListener<?> contentUpdateListener;
    private MainGameView mainGameView;
    private NoticeBoardMenuProvider menuProvider;

    @PostConstruct
    private void initializeEventRegistration() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleNoticeBoardUpdate(NoticeBoardUpdate event) {
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        this.lastProxy = proxy;
        if (proxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_HIDE) {
            this.clearNoticeBoardOfSceneTiedMenu(proxy);
        } else {
            ENoticeBoardType mappedType = this.map((EViewChangeEvent)((ViewChangeCityPlayerProxyJFX)event.getProxy()).getViewChangeEvent());
            if (mappedType != null) {
                this.updateNoticeBoard(proxy, mappedType);
            }
        }
    }

    @Subscribe
    public void handleNoticeBoardClosePersistent(NoticeBoardPersistentClose event) {
        boolean needsUpdate = false;
        block0 : switch (event.getBoardToBeClosed()) {
            case OFFICIAL_MESSAGES: 
            case PERSONAL_MESSAGES: 
            case TRADE_MESSAGES: {
                Iterator iterator = this.noticeBoardMenu.iterator();
                while (iterator.hasNext()) {
                    NoticeBoardMenu menu = (NoticeBoardMenu)iterator.next();
                    List<ENoticeBoardType> types = Arrays.asList(ENoticeBoardType.MESSAGE_TRADE, ENoticeBoardType.MESSAGE_OFFICIAL, ENoticeBoardType.MESSAGE_PERSONAL);
                    if (!types.contains(menu.getType())) continue;
                    iterator.remove();
                    needsUpdate = true;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The persistent closing for " + event.getBoardToBeClosed() + " is not implemented");
            }
        }
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        this.updateAfterStackClearing(proxy, needsUpdate);
    }

    @Subscribe
    public void updateDisplayMessages(DisplayMessage message) {
        if (this.lastProxy instanceof ViewChangeCityPlayerProxyJFX) {
            EViewChangeEvent viewChange = (EViewChangeEvent)((ViewChangeCityPlayerProxyJFX)this.lastProxy).getViewChangeEvent();
            if (viewChange == EViewChangeEvent.SUB_MENU_TRADE_MESSAGE) {
                Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, ENoticeBoardType.MESSAGE_TRADE));
            }
            if (viewChange == EViewChangeEvent.SUB_MENU_PERSONAL_MESSAGE) {
                Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, ENoticeBoardType.MESSAGE_PERSONAL));
            }
            if (viewChange == EViewChangeEvent.SUB_MENU_OFFICIAL_MESSAGE) {
                Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, ENoticeBoardType.MESSAGE_OFFICIAL));
            }
        }
    }

    @Subscribe
    public void handleNavigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.disableNavigationItems();
                break;
            }
            case ENABLE_NAVIGATION: {
                this.enableNavigationItems();
                break;
            }
            default: {
                log.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    private void disableNavigationItems() {
        ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).disableAll();
    }

    private void enableNavigationItems() {
        ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).enableAll();
    }

    private void updateNoticeBoard(ViewChangeCityPlayerProxyJFX proxy, ENoticeBoardType newType) {
        if (this.menuProvider == null) {
            this.initializeMenuProvider();
        }
        if (this.contentUpdate != null) {
            this.contentUpdate.removeListener(this.contentUpdateListener);
            this.contentUpdate = null;
        }
        if (newType.isNoticeBoardMenu()) {
            this.updateNoticeBoardThroughMenu(proxy, newType);
        } else {
            this.updateNoticeBoardThroughContent(proxy, newType);
        }
    }

    private void updateNoticeBoardThroughContent(ViewChangeCityPlayerProxyJFX proxy, ENoticeBoardType newType) {
        Region header = this.contentProvider.createHeader(newType, proxy);
        Region content = this.contentProvider.createContent(newType, proxy);
        this.contentUpdate = this.contentProvider.createObservable(newType, proxy);
        this.contentUpdateListener = (obs, oldValue, newValue) -> Platform.runLater(() -> {
            this.setHeader((Node)this.contentProvider.createHeader(newType, proxy));
            this.setScrollPaneContent((Node)this.contentProvider.createContent(newType, proxy));
        });
        Platform.runLater(() -> this.lambda$updateNoticeBoardThroughContent$5((Node)header, (Node)content));
    }

    private void updateNoticeBoardThroughMenu(ViewChangeCityPlayerProxyJFX proxy, ENoticeBoardType newType) {
        if (!this.isShowNoticeBoardContent()) {
            Platform.runLater(() -> this.resetScrollPane());
        }
        if (this.noticeBoardMenu.isEmpty()) {
            NoticeBoardMenu newMenu = this.menuProvider.createMenu(newType, (ICityPlayerProxyJFX)proxy);
            Platform.runLater(() -> this.addMenu(newMenu));
        } else {
            ENoticeBoardType lastType = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
            if (lastType == newType) {
                Platform.runLater(() -> {
                    NoticeBoardMenu updatedMenu = this.menuProvider.createMenu(lastType, (ICityPlayerProxyJFX)proxy);
                    Dialog dialog = this.mainGameView.getDialog();
                    if (dialog != null) {
                        EDialogType dialogType = dialog.getDialogType();
                        for (NoticeBoardMenuEntry entry : updatedMenu.getMenuEntries()) {
                            if (entry.getDialogType() == null || entry.getDialogType() != dialogType) continue;
                            updatedMenu.deselctAll();
                            entry.setSelected(true);
                            break;
                        }
                    }
                    this.reset(updatedMenu);
                });
            } else {
                NoticeBoardMenu newMenu = this.menuProvider.createMenu(newType, (ICityPlayerProxyJFX)proxy);
                this.closeNoticeBoard();
                this.addMenu(newMenu);
            }
        }
    }

    private void initializeMenuProvider() {
        this.menuProvider = (NoticeBoardMenuProvider)this.context.getBean(NoticeBoardMenuProvider.class);
        this.mainGameView = (MainGameView)this.context.getBean(MainGameView.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handlePersonLeaves(PersonLeavesTavernEvent event) {
        LinkedList linkedList = this.noticeBoardMenu;
        synchronized (linkedList) {
            if (!this.noticeBoardMenu.isEmpty() && this.lastProxy.getCity().equals(event.getCity())) {
                ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
                if (this.lastProxy != null && this.lastProxy instanceof ViewChangeCityPlayerProxyJFX && type == ENoticeBoardType.TAVERN) {
                    if (this.mainGameView != null) {
                        Dialog dialog = this.mainGameView.getDialog();
                        EDialogType mappedDialogType = this.map(event.getPerson());
                        if (dialog != null && dialog.getDialogType() == mappedDialogType) {
                            ((CloseButtonDialog)dialog).executeOnCloseButtonClicked();
                        }
                    }
                    this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, type);
                }
            }
        }
    }

    private EDialogType map(IPerson person) {
        if (person instanceof ISideRoomPerson) {
            return EDialogType.TAVERN_SIDE_ROOM;
        }
        if (person instanceof ICaptain) {
            return EDialogType.TAVERN_CAPTAIN;
        }
        if (person instanceof ISailors) {
            return EDialogType.TAVERN_SAILORS;
        }
        if (person instanceof IWeaponsDealer) {
            return EDialogType.TAVERN_WEAPONS_DEALER;
        }
        if (person instanceof ITraveler) {
            return EDialogType.TAVERN_TRAVELER;
        }
        if (person instanceof ITrader) {
            return EDialogType.TAVERN_TRADER;
        }
        if (person instanceof IContractBroker) {
            return null;
        }
        if (person instanceof IPirate) {
            return EDialogType.TAVERN_PIRATE;
        }
        if (person instanceof IInformant) {
            return EDialogType.TAVERN_INFORMANT_1;
        }
        return null;
    }

    @Subscribe
    public void handleCloseNoticeBoard(NoticeBoardClose event) {
        this.closeNoticeBoard();
    }

    @Subscribe
    public void handleDayChange(ClockTickPostDayChange event) {
        if (!this.noticeBoardMenu.isEmpty()) {
            ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
            if (this.lastProxy != null && type == ENoticeBoardType.TAVERN) {
                Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, type));
            }
        }
    }

    private void clearNoticeBoardOfSceneTiedMenu(ViewChangeCityPlayerProxyJFX proxy) {
        boolean needsUpdate = false;
        Iterator iterator = this.noticeBoardMenu.iterator();
        while (iterator.hasNext()) {
            NoticeBoardMenu menu = (NoticeBoardMenu)iterator.next();
            if (!menu.getType().isTiedToScene()) continue;
            iterator.remove();
            needsUpdate = true;
        }
        this.updateAfterStackClearing(proxy, needsUpdate);
    }

    private void updateAfterStackClearing(ViewChangeCityPlayerProxyJFX proxy, boolean needsUpdate) {
        if (needsUpdate) {
            if (this.noticeBoardMenu.isEmpty()) {
                this.closeNoticeBoard();
            } else {
                ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
                Platform.runLater(() -> this.updateNoticeBoard(proxy, type));
            }
        }
    }

    private ENoticeBoardType map(EViewChangeEvent viewChange) {
        switch (viewChange) {
            case NOTICE_MARKET_BOOTH: {
                return ENoticeBoardType.MARKET_PLACE;
            }
            case NOTICE_SHIPYARD: {
                return ENoticeBoardType.SHIPYARD;
            }
            case NOTICE_TAVERN: {
                return ENoticeBoardType.TAVERN;
            }
            case NOTICE_TRADE: {
                return ENoticeBoardType.TRADING;
            }
            case NOTICE_TRADING_OFFICE: {
                return ENoticeBoardType.TRADING_OFFICE;
            }
            case NOTICE_LOANER: {
                return ENoticeBoardType.LOANER;
            }
            case NOTICE_CITY_HALL_BOARD: {
                return ENoticeBoardType.CITY_HALL_NOTICE_BOARD;
            }
            case NOTICE_CITY_HALL_TREASURY: {
                return ENoticeBoardType.CITY_HALL_MAYORS_OFFICE;
            }
            case NOTICE_CITY_HALL_ALDERMAN: {
                return ENoticeBoardType.CITY_HALL_ALDERMAN_OFFICE;
            }
            case NOTICE_CITY_HALL_MEETINGROOM: {
                return ENoticeBoardType.CITY_HALL_MEETINGROOM;
            }
            case MAIN_VIEW_CHURCH: {
                return ENoticeBoardType.CHURCH;
            }
            case MAIN_VIEW_GUILD: {
                return ENoticeBoardType.GUILD;
            }
            case MAIN_VIEW_ARMORY: {
                return ENoticeBoardType.ARMORY;
            }
            case NOTICE_SHIP_WARE_INFO: {
                return ENoticeBoardType.SHIP_WARE_INFO;
            }
            case TRADE_MESSAGES: 
            case SUB_MENU_TRADE_MESSAGE: {
                return ENoticeBoardType.MESSAGE_TRADE;
            }
            case PERSONAL_MESSAGES: 
            case SUB_MENU_PERSONAL_MESSAGE: {
                return ENoticeBoardType.MESSAGE_PERSONAL;
            }
            case OFFICIAL_MESSAGES: 
            case SUB_MENU_OFFICIAL_MESSAGE: {
                return ENoticeBoardType.MESSAGE_OFFICIAL;
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$updateNoticeBoardThroughContent$5(Node header, Node content) {
        this.setHeader(header);
        this.setScrollPaneContent(content);
        this.contentUpdate.addListener(this.contentUpdateListener);
    }
}

