package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianHorizontalSelector;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.DisplayMessages;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.MessageConfiguration;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Dialog for configuring messages.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Aug 05, 2018
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class MessageConfigurationDialog extends CloseButtonDialog {
    /** Reference to the proxy view model */
    private final ICityPlayerProxyJFX proxy;

    @Autowired
    private MessageConfiguration messageConfiguration;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DisplayMessages displayMessages;

    private OpenPatricianHorizontalSelector tradeSelector;
    private OpenPatricianHorizontalSelector personalSelector;
    private OpenPatricianHorizontalSelector officialSelector;

    public MessageConfigurationDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.title",
                new Object[]{}, locale.getCurrentLocal()));
        ReadOnlyDoubleProperty widthProperty = new SimpleDoubleProperty(WRAPPING_WIDTH);
        VBox vbox = new VBox(10);
        vbox.setLayoutY(100);
        vbox.setLayoutX(INSET);
        Label lbl = new Label(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.trade",
                new Object[]{}, locale.getCurrentLocal()));
        lbl.getStyleClass().add("dialogText");
        lbl.setId("tradeLbl");
        tradeSelector = new OpenPatricianHorizontalSelector(widthProperty);
        tradeSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20",
                new Object[]{}, locale.getCurrentLocal()));
        tradeSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50",
                new Object[]{}, locale.getCurrentLocal()));
        tradeSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100",
                new Object[]{}, locale.getCurrentLocal()));
        tradeSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll",
                new Object[]{}, locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton deleteTrade = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll",
                new Object[]{}, locale.getCurrentLocal()));
        deleteTrade.setId("tradeTradeDelete");
        deleteTrade.setOnAction(evt -> {
            displayMessages.tradeMessagesProperty().removeIf(msg -> msg.getCategory().equals(EMessageCategory.TRADE));
        });
        tradeSelector.selectedIndexProperty().setValue(mapBack(messageConfiguration.getRetainedTradeMessages()));
        vbox.getChildren().addAll(lbl, tradeSelector, deleteTrade);

        lbl = new Label(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.personal",
                new Object[]{}, locale.getCurrentLocal()));
        lbl.getStyleClass().add("dialogText");
        lbl.setId("personalLbl");
        personalSelector = new OpenPatricianHorizontalSelector(widthProperty);
        personalSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20",
                new Object[]{}, locale.getCurrentLocal()));
        personalSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50",
                new Object[]{}, locale.getCurrentLocal()));
        personalSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100",
                new Object[]{}, locale.getCurrentLocal()));
        personalSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll",
                new Object[]{}, locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton personalTrade = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll",
                new Object[]{}, locale.getCurrentLocal()));
        personalTrade.setId("personalTradeDelete");
        personalTrade.setOnAction(evt -> {
            displayMessages.personalMessagesProperty().removeIf(msg -> msg.getCategory().equals(EMessageCategory.PERSONAL));
        });
        personalSelector.selectedIndexProperty().setValue(mapBack(messageConfiguration.getRetainedPersonalMessages()));
        vbox.getChildren().addAll(lbl, personalSelector, personalTrade);

        lbl = new Label(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.official",
                new Object[]{}, locale.getCurrentLocal()));
        lbl.getStyleClass().add("dialogText");
        lbl.setId("officialLbl");
        officialSelector = new OpenPatricianHorizontalSelector(widthProperty);
        officialSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20",
                new Object[]{}, locale.getCurrentLocal()));
        officialSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50",
                new Object[]{}, locale.getCurrentLocal()));
        officialSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100",
                new Object[]{}, locale.getCurrentLocal()));
        officialSelector.valuesProperty().add(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll",
                new Object[]{}, locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton officialTrade = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll",
                new Object[]{}, locale.getCurrentLocal()));
        officialTrade.setId("officialTradeDelete");
        personalTrade.setOnAction(evt -> {
            displayMessages.officialMessagesProperty().removeIf(msg -> msg.getCategory().equals(EMessageCategory.OFFICIAL));
        });
        officialSelector.selectedIndexProperty().setValue(mapBack(messageConfiguration.getRetainedOfficialMessages()));
        vbox.getChildren().addAll(lbl, officialSelector, officialTrade);

        getContent().add(vbox);
    }

    @Override
    public void executeOnCloseButtonClicked() {
        messageConfiguration.setRetainedTradeMessages(map(tradeSelector.getSelectedIndex()));
        messageConfiguration.setRetainedPersonalMessages(map(personalSelector.getSelectedIndex()));
        messageConfiguration.setRetainedOfficialMessages(map(officialSelector.getSelectedIndex()));
        displayMessages.ensureMessagePoolSize();
        super.executeOnCloseButtonClicked();
    }

    private int map(int retainedIndex) {
        if (retainedIndex == 0) {
            return 20;
        }
        if (retainedIndex == 1) {
            return  50;
        }
        if (retainedIndex == 2) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    private int mapBack(int retainedAmount) {
        if (retainedAmount <= 20) {
            return 0;
        }
        if (retainedAmount <= 50) {
            return 1;
        }
        if (retainedAmount <= 100) {
            return 2;
        }
        return 3;
    }
}
