package ch.sahits.game.openpatrician.display.dialog.church;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jul 10, 2015
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ChurchExtensionDialog extends CloseButtonDialog {
    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier("xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelStateAccessor churchProvider;


    private MoneyTransfer moneyTransfer;

    public ChurchExtensionDialog(ICityPlayerProxyJFX city) {
        super();
        this.city = city;

    }


    @PostConstruct
    private void initializeDialog() {
        final IChurch church = churchProvider.getChurch(city.getCity());
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchExtensionDialog.title", new Object[]{}, locale.getCurrentLocal()));
        // no extendsion
        if (!church.getExtensionLevel().getNextExtensionLevel().isPresent()) {
            String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchExtensionDialog.noExtension", new Object[]{}, locale.getCurrentLocal());
            DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
            getContent().addAll(text);
        } else {
            // extendsion
            String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchExtensionDialog.introText", new Object[]{}, locale.getCurrentLocal());
            DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
            VBox box = new VBox(text);

            final ICompany company = city.getPlayer().getCompany();

            moneyTransfer = fxUtils.getMoneyTransfer(imageLoader);
            moneyTransfer.setStepSize(500);
            moneyTransfer.maxTransfereableProperty().bind(company.cashProperty());
            moneyTransfer.setAmount(0);

            box.setLayoutX(50);
            box.setLayoutY(CLOSE_BTN_Y_POS - 500);
            moneyTransfer.setPadding(new Insets(100, 0, 0, 100));
            box.getChildren().addAll(moneyTransfer);

            final int actionButtonX = (WIDTH - 124) / 2;

            String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.donate", new Object[]{}, locale.getCurrentLocal());
            final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
            action.getStyleClass().add("actionButton");
            action.setOnAction(getAction(church));
            action.setLayoutX(actionButtonX);
            action.setLayoutY(CLOSE_BTN_Y_POS - 24);
            BooleanBinding actionEnabled = actionEnabledBinding();
            action.setDisable(!actionEnabled.get());
            actionEnabled.addListener((observableValue, oldValue, newValue) -> action.setDisable(!newValue));


            getContent().addAll(box, action);
        }

    }

    private BooleanBinding actionEnabledBinding() {
        return new BooleanBinding() {
            {
                super.bind(moneyTransfer.amountProperty());
            }
            @Override
            protected boolean computeValue() {
                return moneyTransfer.getAmount() > 0;
            }
        };
    }

    private EventHandler<MouseEvent> getAction(final IChurch church) {
        return evt -> {
            try {
                final ICompany company = city.getPlayer().getCompany();
                company.updateCash(-moneyTransfer.getAmount());
                church.makeDonation(moneyTransfer.getAmount());
                city.getCity().getReputation(city.getPlayer()).update(moneyTransfer.getAmount() / 1000);
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                log.error("Failed to make donation", e);
            }
        };
    }


    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_CHURCH);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
