package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.binding.LongBinding;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 03, 2015
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TreasuryDialog extends CloseButtonDialog {

    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelStateAccessor cityHallAccessor;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private MapService cityService;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    @Qualifier("xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;

    private final ICityPlayerProxyJFX city;

    private HBox selectionBox = null;
    private GridPane grid;


    public TreasuryDialog(ICityPlayerProxyJFX city) {
        super();
        this.city = city;
        getStylesheets().add(this.getClass().getResource("/styles/base.css").toExternalForm());
        getStyleClass().add("dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.title", new Object[]{}, locale.getCurrentLocal()));
        LocalDateTime now = date.getCurrentDate();
        LocalDateTime firstOfMont = now.minusDays(now.getDayOfMonth() - 1);
        Object[] args = new Object[]{modelTranslator.toShortDate(firstOfMont)};

        String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.subtitle", args, locale.getCurrentLocal());
        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
        text.setLayoutX(2 * FRAME_BORDER);
        getContent().add(text);
        final ICityHall cityHall = cityHallAccessor.getCityHall(city.getCity());
        ITreasury treasury = cityHall.getTreasury();

        LongBinding total = new LongBinding() {
            {
                super.bind(treasury.paidTaxesProperty(), treasury.paidSpecialTaxesProperty(), treasury.donationsProperty(), treasury.cityGuardCostsProperty(),
                        treasury.buildingCostsProperty(), treasury.outriggerCostsProperty(), treasury.siegeCostsProperty(), treasury.otherCostsProperty(), treasury.otherIncomeProperty());
            }
            @Override
            protected long computeValue() {
                return (treasury.getPaidTaxes() + treasury.getPaidSpecialTaxes() + treasury.getDonations()) - treasury.getCityGuardCosts() - treasury.getBuildingCosts()
                        - treasury.getOutriggerCosts() - treasury.getSiegeCosts() - treasury.getOtherCosts() + treasury.getOtherIncome();
            }
        };

        Table tableModel = new Table();
        TableHeader header = new TableHeader(2);
        header.add(new StaticTextTableCell(""));
        header.add(new StaticTextTableCell(""));
        tableModel.setHeader(header);
        tableModel.setColumnWidth(300, 100);
        tableModel.setAligenment(0, HPos.LEFT);
        tableModel.setAligenment(1, HPos.RIGHT);

        TableRow row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.headAndPropertyTax", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        CoinPriceAlwaysVisible control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.paidTaxesProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.specialTaxes", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.paidSpecialTaxesProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donation", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.donationsProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donation.guardsCost", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.cityGuardCostsProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.buildCosts", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.buildingCostsProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.outriggerCosts", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.outriggerCostsProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.siege", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.siegeCostsProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.otherCosts", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.otherCostsProperty().add(treasury.otherIncomeProperty()).asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.total", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(total.asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        tableModel.add(row);

        row = new TableRow();
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.available", new Object[]{}, locale.getCurrentLocal());
        row.add(new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind(treasury.cashProperty().asString());
        row.add(new ControlTableCell(control));
        tableModel.add(row);

        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);

        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donate", new Object[]{}, locale.getCurrentLocal());
        OpenPatricianLargeWaxButton donate = new OpenPatricianLargeWaxButton(template);
        donate.getStyleClass().add("actionButton");
        donate.setId("donate");
        template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[]{}, locale.getCurrentLocal());
        OpenPatricianLargeWaxButton withdraw = new OpenPatricianLargeWaxButton(template);
        withdraw.getStyleClass().add("actionButton");
        if (!city.getPlayer().getRank().equals(ESocialRank.MAYOR) || !city.getPlayer().getHometown().equals(city.getCity())) {
               withdraw.setVisible(false);
        }
        withdraw.setId("withdraw");
        donate.setOnAction(getDonateAction(donate, withdraw));
        withdraw.setOnAction(getWithdrawalAction(donate, withdraw));
        row = new TableRow();
        row.add(new ControlTableCell(donate));
        row.add(new ControlTableCell(withdraw));
        tableModel.add(row);


        grid = fxUtils.createGridPaneFromModel(tableModel);
        grid.getStyleClass().add("tableFont");
        grid.setLayoutX(50);
        grid.setLayoutY(CLOSE_BTN_Y_POS - 500);
        getContent().add(grid);




    }

    private EventHandler<MouseEvent> getWithdrawalAction(final OpenPatricianLargeWaxButton donation, final OpenPatricianLargeWaxButton withdraw) {
        return (mouseEvent) -> {
            try {
                grid.getChildren().removeAll(donation, withdraw);
                Treasury treasury = (Treasury) cityHallAccessor.getCityHall(city.getCity()).getTreasury();
                MoneyTransfer moneyTransfer = fxUtils.getMoneyTransfer(imageLoader);
                moneyTransfer.setStepSize(100);
                moneyTransfer.maxTransfereableProperty().bind(treasury.cashProperty());
                moneyTransfer.setAmount(0);

                selectionBox = new HBox(5);
                String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[]{}, locale.getCurrentLocal());
                OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template);
                action.getStyleClass().add("actionButton");
                action.setId("withdrawlButton");
                selectionBox.getChildren().addAll(moneyTransfer, action);
                selectionBox.setLayoutX(100);
                selectionBox.setLayoutY(CLOSE_BTN_Y_POS - 50);
                getContent().add(selectionBox);
                action.setOnAction((evt) -> {
                    try {
                        final int withdrawl = moneyTransfer.getAmount();
                        treasury.subtractOtherCosts(withdrawl);
                        city.getPlayer().getCompany().updateCash(withdrawl);
                        // todo: andi 4/4/15: decrease the players standing
                        executeOnCloseButtonClicked();
                    } catch (RuntimeException e) {
                        log.error("Failed to withdraw cash", e);
                    }
                });
            } catch (RuntimeException e) {
                log.error("Failed to withdraw from the city", e);
            }
        };
    }

    private EventHandler<MouseEvent> getDonateAction(final OpenPatricianLargeWaxButton donation, final OpenPatricianLargeWaxButton withdraw) {
        return (mouseEvent) -> {
            try {
                grid.getChildren().removeAll(donation, withdraw);
                final ICompany company = city.getPlayer().getCompany();
                MoneyTransfer moneyTransfer = fxUtils.getMoneyTransfer(imageLoader);
                moneyTransfer.setStepSize(100);
                moneyTransfer.maxTransfereableProperty().bind(company.cashProperty());
                moneyTransfer.setAmount(0);
                selectionBox = new HBox(5);

                String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donate", new Object[]{}, locale.getCurrentLocal());
                OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template);
                action.getStyleClass().add("actionButton");
                action.setId("donateButton");

                selectionBox.getChildren().addAll(moneyTransfer, action);

                selectionBox.setLayoutX(100);
                selectionBox.setLayoutY(CLOSE_BTN_Y_POS - 50);
                getContent().add(selectionBox);
                action.setOnAction((e) -> {
                    Treasury treasury = (Treasury) cityHallAccessor.getCityHall(city.getCity()).getTreasury();
                    final int donations = moneyTransfer.getAmount();
                    treasury.addDonations(donations);
                    company.updateCash(-donations);
                    // todo: andi 4/4/15: increase the players standing
                    executeOnCloseButtonClicked();
                });
            } catch (RuntimeException e) {
                log.error("Failed to donate to the city", e);
            }

        };
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }

}
