package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.ChildDeathState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog displaying the dairy entry for a childs death.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 11, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class ChildDeathDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private DateService dateService;
    private ChildDeathState state;

    public ChildDeathDialog(ChildDeathState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        int age = dateService.getAge(state.getChild().getBirthDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        addDecoratedText("letter.dairy.entry", "diryEntry");
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildDeathDialog.childDeath", "childDeath", state.getChild().getName(), age);
    }
}
