package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageFeastRequestState;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;

/**
 * Dialog to display the request to provide wares for a wedding.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Oct 28, 2018
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageFeastRequestDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private DateService dateService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private ClientViewState clientViewState;

    private final MarriageFeastRequestState state;


    public MarriageFeastRequestDialog(MarriageFeastRequestState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String date = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation().getName(), date);
        addVerticalSpacer(20);
        if (state.isGenderMale()) {
            addDecoratedText("letter.salutation.male", "salutationMale", state.getToLastName());
        } else {
            addDecoratedText("letter.salutation.female", "salutationFemale", state.getToLastName());
        }
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.events.MarriageFeastRequestDialog.content", "content");
        LocalDateTime decisionDeadline = state.getDate().plusMonths(1);

        if (!dateService.isPast(decisionDeadline)) {
            OpenPatricianLargeWaxButton button = addActionButton("ch.sahits.game.openpatrician.display.dialog.events.MarriageFeastRequestDialog.accept", "acceptBtn");
            button.setId("acceptBtn");
            if (state.isAccepted()) {
               button.setDisable(true);
            } else {
                button.setOnAction(event -> {
                    taskList.add(taskFactory.getMarriageFeastDelivery(decisionDeadline, clientViewState.getPlayer(), state.getLocation()));
                    state.setAccepted(true);
                    executeOnCloseButtonClicked();
                });
            }
        }
    }
}
