package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog displaying the social advancement
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 10, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class SocialAdvancementDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private SocialAdvancementState state;

    public SocialAdvancementDialog(SocialAdvancementState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        String newRank = modelTranslations.getLocalDisplayName(state.getRank());
        switch (state.getRank()) {
            case ALDERMAN:
                addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advanceAlderman", "advanceAlderman", letterDate);
                break;
            case MAYOR:
                addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advanceMayor", "advanceMayor", state.getLocation(), letterDate);
                break;
            default:
                addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advance", "advance", state.getLocation(), newRank);
                break;
        }
    }
}
