package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernConcurrentDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernConcurrentDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getConcurrent());
        setTitle(((IConcurrent)currentPerson.get()).getName());
    }
    @PostConstruct
    private void initializeDialog() {
        initializeButtons();
        IConcurrent concurrent = (IConcurrent) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.dialog",
                new Object[]{city.getPlayer().getLastName(), concurrent.getName(), concurrent.getPremium()}, locale.getCurrentLocal());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, new HashMap<>());

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IConcurrent concurrent = (IConcurrent) currentPerson.get();
                int minutes = rnd.nextInt(600);
                LocalDateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                DialogTemplate template = DialogTemplate.builder()
                        .closable(true)
                        .titleKey("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.acceptTitle")
                        .messageKey("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.acceptMessage")
                        .messageArgs(new Object[]{city.getCity().getName(), concurrent.getConcurrentName()})
                        .build();
                taskFactory.getPostponedDisplayDialogMessage(postMessage, EMessageCategory.TRADE, template);
                TimedTask reconsialistation = taskFactory.getConcurrentReconciliation();
                // Order of the client to sink the opponents ship
                eventHandlerFactory.getSinkConcurrentsShipOrder(concurrent.getConcurrentPlayer(), city.getPlayer(), 20, concurrent.getPremium(), reconsialistation);
                // Postponed order of the opponent to sink the clients ship
                taskFactory.getOpponentsOrder(concurrent.getConcurrentPlayer(), concurrent.getClientPlayer(), city.getPlayer(), concurrent.getPremium() * 2);
                concurrent.leave();
                city.getPlayer().updateCrimialDrive(1);
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                log.error("Failed to accept concurrent attack offer", e);
            }

        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }

}
