package ch.sahits.game.openpatrician.display.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.geometry.Point2D;
import lombok.Value;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Sep 08, 2018
 */
@Value
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class FocusLocationEvent implements IEventMetaDataProvider {
    private Point2D focus;
    private String className;
    private String methodName;

    public FocusLocationEvent(Point2D focus) {
        this.focus = focus;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
