package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 19, 2016
 */
@Slf4j
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class GuildScenePolygonInitializer extends AbstractMarketPlaceBuildingPolygonInitializer{

    public GuildScenePolygonInitializer() {
        super("images/scene/guildInterior");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "Floor":
                try {
                    return createBackToMarketPlaceEvent();
                } catch (RuntimeException e) {
                    log.error("Failed to switch back to market place", e);
                }
            default:
                throw new IllegalStateException("Unhandled polygon action: "+name);
        }
    }
}
