package ch.sahits.game.openpatrician.display.gameplay.impl;


import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
/**
 * Component initializing the polygons for the port scene
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 10, 2013
 *
 */
@Slf4j
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class PortScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

	public PortScenePolygonInitializer(){
		super("images/scene/portScene");
	}
	@Override
	protected EventHandler<MouseEvent> createEventHandler(final String name) {
		try {
			switch (name) {
				case "shipYard": {
					return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_SHIPYARD);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
				}
				case "tavern": {
					return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_TAVERN);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
				}
				case "LoadingCrane": {
					return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TRADE);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TRADE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
				}
				case "Stairs": {
					// replace the scene with the market scene
					return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_MARKET);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
				}
				case "Loaner": {
					// replace the scene with the market scene
					return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_LOANER);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_LOANER);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
				}
				case "TradingOffice": {
					return arg0 -> {
                        ICityPlayerProxyJFX cityProxy = viewState.getCurrentCityProxy().get();
                        if (viewState.getPlayer().findTradingOffice(cityProxy.getCity()).isPresent()) {
                            ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(cityProxy, EViewChangeEvent.NOTICE_TRADING_OFFICE);
                            clientEventBus.post(new NoticeBoardUpdate(proxy));
                            clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        } else {
                            log.debug("There is no trading office for {} {} in {}", viewState.getPlayer().getName(), viewState.getPlayer().getLastName(), cityProxy.getCity().getName());
                        }
                    };
				}
				default:
					throw new IllegalStateException("Unhandled polygon action: " + name);
			}
		} catch (RuntimeException e) {
			log.error("Failed to switch to different scene: "+name, e);
			return null;
		}
	}

}
