package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.HANDLER)
public class ShipyardSceneEventHandler implements ISceneEventHandler {
    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
            if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
                ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
                // trade city ship
                if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_SHIPYARD) {
                    // Dialog City ship
                    dialogContoller.setNewDialog(EDialogType.SHIPYARD_CONSTRUCTION);
                }
                 // Scene change port
                if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                    currentScene.set(EScene.PORT);
                    dialogContoller.changeScene();
                }
                // Scene armory
                if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_ARMORY) {
                    currentScene.set(EScene.ARMORY);
                    dialogContoller.changeScene();
                }
            }
            if (eventNotice instanceof EDialogType) {
                dialogContoller.replaceDialog((EDialogType) eventNotice);
            }
    }
}
