package ch.sahits.game.openpatrician.display.javafx.action;


import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * This action handles the selling of wares from the storage to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class Storage2CityJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;
	@Autowired
	private TradeService tradeService;

	public Storage2CityJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		Optional<ITradingOffice> optOffice = transfer.getPlayer().findTradingOffice(transfer.getCity());
		if (optOffice.isPresent()) {
			ITradingOffice office = optOffice.get();
			int amountInStorage = office.getWare(ware).getAmount();
			if (amountInStorage > 0) {
				int amount2Move = transfer.getAmount(amountInStorage);
				tradeService.sellFromStorageToCity(office, transfer.getPlayer(), transfer.getCity(), ware, amount2Move, Optional.empty());
			} // end stored amount
		} // end office 
	}
	
}
