package ch.sahits.game.openpatrician.display.model;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.experimental.Delegate;

/**
 * Proxy object for city player for view changes.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 19, 2011
 *
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class ViewChangeCityPlayerProxyJFX implements ICityPlayerProxyJFX {
	
	private final IViewChangeEvent viewchange;
	@Delegate
	private final ICityPlayerProxyJFX proxy;
	/**
	 * Constructor by making a copy of the passed proxy
	 * @param proxy city proxy
	 * @param event the transported event.
	 */
	public ViewChangeCityPlayerProxyJFX(ICityPlayerProxyJFX proxy, IViewChangeEvent event){
		this.proxy=proxy;
		this.viewchange=event;
	}
	
	public IViewChangeEvent getViewChangeEvent(){
		return viewchange;
	}

}
