package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.GenericTriple;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.IDoubleSelectableCheatCommand;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.scene.input.KeyCode;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * Cheat command to add a weapon to a ship using CTRL+W.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 05, 2018
 */
@Getter
@Slf4j
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class AddWeaponToShipCheat implements IDoubleSelectableCheatCommand {
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.W;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.AddWeaponToShipCheat.desc";
    @ListType(GenericTriple.class)
    private final List<GenericTriple<String>> firstOptions = new ArrayList<>();
    @ListType(GenericTriple.class)
    private final List<GenericTriple<String>> secondOptions = new ArrayList<>();
    @Setter
    private GenericTriple<String> selectedFirstOption;
    @Setter
    private GenericTriple<String> selectedSecondOption;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @PostConstruct
    private void init() {
        EWeapon[] weapons = new EWeapon[]{EWeapon.BALLISTA_SMALL, EWeapon.BALLISTA_BIG, EWeapon.TREBUCHET_SMALL,
                EWeapon.TREBUCHET_BIG, EWeapon.BOMBARD, EWeapon.CANNON};
        for (EWeapon weapon : weapons) {
            String display = messageSource.getMessage(weapon.name(), new Object[0], locale.getCurrentLocal());
            firstOptions.add(new GenericTriple<>(String.valueOf(weapon.ordinal()), weapon.name(), display));
        }
        selectedFirstOption = firstOptions.get(0);
    }

    @Override
    public void setupModel() {
        ClientViewState viewState = context.getBean(ClientViewState.class);
        if (viewState.getCurrentCityProxy().isPresent()) {
            List<IShip> ships = viewState.getCurrentCityProxy().get().getPlayersShips();
            for (IShip ship : ships) {
                secondOptions.add(new GenericTriple<>(ship.getUuid(), ship.getUuid(), ship.getName()));
            }
            if (!ships.isEmpty()) {
                selectedSecondOption = secondOptions.get(0);
            }
        }
    }

    @Override
    public void execute() {
        ClientViewState viewState = context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        List<IShip> fleet = player.getFleet();
        IShip ship = null;
        for (IShip s : fleet) {
            if (s.getUuid().equals(selectedSecondOption.getFirst())) {
                ship = s;
                break;
            }
        }
        if (ship != null) {
            EWeapon weapon = EWeapon.valueOf(selectedFirstOption.getSecond());
            ShipService shipService = context.getBean(ShipService.class);
            shipService.placeWeapon(weapon, ship);
            log.debug("Cheated one cannon onto the active ship: " + ship.getName());
        }
    }
}
