package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHall;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.scene.input.KeyCode;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/**
 * Cheat to become mayor in the players home town.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 06, 2018
 */
@Getter
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class BecomeMayorCheat implements ICheatCommand {
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.M;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.BecomeMayorCheat.desc";
    @Autowired
    private ApplicationContext context;

    @Override
    public void execute() {
        ClientViewState viewState = context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        ICity city = player.getHometown();
        CityHallList cityHalls = context.getBean(CityHallList.class);
        CityHall cityHall = (CityHall) cityHalls.findCityHall(city).get();
        cityHall.setMayor(player);
        player.updateRank(ESocialRank.MAYOR);
    }
}
