package ch.sahits.game.openpatrician.display.model.cheat;

import ch.qos.logback.classic.Level;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.display.javafx.SeamapImageView;
import ch.sahits.game.openpatrician.engine.player.strategy.AlwaysJoinGuildMinCashStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseBuyWeaponStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseHireCaptainForShipAboveSizeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseHireCaptainStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseHireDismissTradeManagerStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseJoinGuildStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BiggestShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BlockadeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BuyWeaponHighPirateActivityHalfSlotsFilledStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BuyWeaponHighPirateSuccessAllSlotsFilledStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.BuyWeaponHighPirateSuccessHalfSlotsFilledStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageDeliveryTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageHintContext;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageStrategyHint;
import ch.sahits.game.openpatrician.engine.player.strategy.CheapProductionTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectCelebrationWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownSnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeSnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCityHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWestCitySnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionConstructionHometownWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionConstructionTradingOfficeWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionConstructionWestCityWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.DangerBasedShipUpgradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.DefaultHireSailorsStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.DynamicTradeRouteStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EightyPercentRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.FleetBasedEventDecisionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HireCaptainAlwaysStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HireCaptainForMediumShipsStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HireCaptainNeverStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HireDismissTradeManagerMinStorageCapacityStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HireDismissTradeManagerStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HometownBiggestShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HometownJoinGuildMinCashStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HometownRandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.HometownRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.KontorTypeCityRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.MoneyBasedEventDecisionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.NearHometownJoinGuildMinCashStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.NearTradingOfficeJoinGuildMinCashStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.OnlyTradingOfficeRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.ProductionChainTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.RandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.StorageBasedEventDecisionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyCentralTradingStationAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyHometownAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TakeLoanLowMoneyLongestDurationStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradeRouteTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradingOfficeBiggestShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradingOfficeJoinGuildMinCashStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradingOfficeRandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.WestCityBiggestShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.WestCityRandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.WestRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AbstractAggregateDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedBuyTradingOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesCheckedSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AmountBasedAggregatedDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BaseBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradingOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckedTransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.SellDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.SellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToShipTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.engine.sea.AStar;
import ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask;
import ch.sahits.game.openpatrician.javafx.control.skin.ShipIconSkin;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.impl.Company;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.scene.input.KeyCode;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Implementation of the verbose cheat, activated by CTRL+V.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 04, 2018
 */
@Slf4j
@Getter
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class VerboseCheat implements ICheatCommand {
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.V;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.VerboseCheat.desc";
    @Autowired
    private ApplicationContext context;

    private boolean debugOutputOn = false;

    @Override
    public void execute() {
        debugOutputOn = !debugOutputOn;
        List<String> loggerNames = getLoggerNames();
        if (debugOutputOn) {
            // set log levels to trace
            for (String loggerName : loggerNames) {
                setLevel(loggerName, Level.TRACE);
            }
            log.debug("Set log level for some loggers to TRACE");
            printGameState();
        } else {
            // set log level to debug
            for (String loggerName : loggerNames) {
                setLevel(loggerName, Level.DEBUG);
            }
            log.debug("Set log level for some loggers to DEBUG");
        }
        try {
            SeamapImageView seamap = context.getBean(SeamapImageView.class);
            seamap.toggleVisibilityAllShips();
        } catch (UnsatisfiedDependencyException e) {
            log.warn("Tried to toggle on visibility of all ships before Sea Map was opened for the first time");
        }
    }

    private void printGameState() {
        StringBuilder sb = new StringBuilder();
        PlayerList players = context.getBean(PlayerList.class);
        IMap map = context.getBean(IMap.class);
        for (IPlayer player : players) {
            boolean human = player instanceof IHumanPlayer;
            sb.append("Player: ");
            if (human) {
                sb.append("human, ");
            } else {
                sb.append("ai, ");
            }
            // List players name home town cash
            sb.append(player.getName())
                    .append(" ")
                    .append(player.getLastName())
                    .append(" from ")
                    .append(player.getHometown().getName())
                    .append(" has $")
                    .append(player.getCompany().getCash())
                    .append("\n");
            //   List trading offices wares
            for (ICity city : map.getCities()) {
                Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
                if (optOffice.isPresent()) {
                    sb.append("\tTrading office in ")
                            .append(city.getName())
                            .append(":\n");
                    ITradingOffice office = optOffice.get();
                    for (EWare ware : EWare.values()) {
                        AmountablePrice<IWare> amountable = office.getWare(ware);
                        if (amountable.getAmount() > 0) {
                            sb.append("\t\t")
                                    .append(ware.name())
                                    .append(": ")
                                    .append(amountable.getAmount())
                                    .append(" @ ")
                                    .append(amountable.getAVGPrice())
                                    .append("\n");
                        }
                    }
                }
            }
            //   List ships captain sailor weapons loaded wares
            for (IShip ship : player.getFleet()) {
                sb.append("\tShip ")
                        .append(ship.getShipType())
                        .append(" @ ")
                        .append(ship.getLocation())
                        .append(" ")
                        .append(ship.getName())
                        .append(" owned by ")
                        .append(ship.getOwner().getName())
                        .append(" ")
                        .append(ship.getOwner().getLastName())
                        .append(", ");
                Optional<ICaptain> optCaptain = ship.getCaptian();
                if (optCaptain.isPresent()) {
                    ICaptain captain = optCaptain.get();
                    sb.append("Captain")
                            .append(captain.getName())
                            .append(", age: ")
                            .append(captain.getAge())
                            .append(", salary")
                            .append(captain.getSalary())
                            .append(", ");
                }
                sb.append("nb Sailors: ")
                        .append(ship.getNumberOfSailors())
                        .append(", ");
                Map<IWeapon, Integer> weaponCount = new HashMap<>();
                for (EWeapon weapon : EWeapon.values()) {
                    int amount = ship.getWeaponAmount(weapon);
                    if (amount > 0) {
                        weaponCount.put(weapon, amount);
                    }
                }
                if (weaponCount.isEmpty()) {
                    sb.append("no weapons\n");
                } else {
                    for (IWeapon weapon : weaponCount.keySet()) {
                        sb.append("\t\t")
                                .append(weaponCount.get(weapon))
                                .append(" ")
                                .append(weapon)
                                .append("\n");
                    }
                }
                for (EWare ware : EWare.values()) {
                    AmountablePrice<IWare> amountable = ship.getWare(ware);
                    if (amountable.getAmount() > 0) {
                        sb.append("\t\t")
                                .append(ware.name())
                                .append(": ")
                                .append(amountable.getAmount())
                                .append(" @ ")
                                .append(amountable.getAVGPrice())
                                .append("\n");
                    }
                }
            }
        }
        log.debug(sb.toString());
    }


    /** Override the logging level of a given logger, return the previous level */
    private Level setLevel(String loggerName, Level level) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger) org.slf4j.LoggerFactory.getLogger(loggerName);
        Level oldLevel = logger.getLevel();
        logger.setLevel(level);
        return oldLevel;
    }

    static List<String> getLoggerNames() {
        List<String> loggerNames = new ArrayList<>();
        // Pathfinding
        loggerNames.add(AStar.class.getName());
        loggerNames.add(SeamapImageView.class.getName());
        loggerNames.add(PathInterpolator.class.getName());
        loggerNames.add(ShipPositionUpdateTask.class.getName());
        loggerNames.add(ShipIconSkin.class.getName());
        // Trading
        loggerNames.add(AbstractAggregateDumpTradeStep.class.getName());
        loggerNames.add(AggregatedBuyTradeStep.class.getName());
        loggerNames.add(AggregatedBuyTradingOfficeTradeStep.class.getName());
        loggerNames.add(AggregatedCheckedBuyTradeStep.class.getName());
        loggerNames.add(AggregatesCheckedSellTradeStep.class.getName());
        loggerNames.add(AggregatesDumpTradeStep.class.getName());
        loggerNames.add(AggregatesSellTradeStep.class.getName());
        loggerNames.add(AmountBasedAggregatedDumpTradeStep.class.getName());
        loggerNames.add(BaseBuyTradeStep.class.getName());
        loggerNames.add(BuyTradeStep.class.getName());
        loggerNames.add(BuyTradingOfficeTradeStep.class.getName());
        loggerNames.add(BuyWeaponTradeStep.class.getName());
        loggerNames.add(CheckedBuyTradeStep.class.getName());
        loggerNames.add(CheckedSellTradeStep.class.getName());
        loggerNames.add(CheckedTransferToOfficeTradeStep.class.getName());
        loggerNames.add(CheckForRepairTradeStep.class.getName());
        loggerNames.add(CheckHireCaptainTradeStep.class.getName());
        loggerNames.add(GuildJoinTradeStep.class.getName());
        loggerNames.add(HireDismissTradeManagerTradeStep.class.getName());
        loggerNames.add(HireSailorsStep.class.getName());
        loggerNames.add(PayBackLoanTradeStep.class.getName());
        loggerNames.add(SellDumpTradeStep.class.getName());
        loggerNames.add(SellTradeStep.class.getName());
        loggerNames.add(TakeLoanTradeStep.class.getName());
        loggerNames.add(TransferToOfficeTradeStep.class.getName());
        loggerNames.add(TransferToShipTradeStep.class.getName());
        loggerNames.add(TravelToTradeStep.class.getName());
        loggerNames.add(UpgradeShipTradeStep.class.getName());

        loggerNames.add(AlwaysJoinGuildMinCashStrategy.class.getName());
        loggerNames.add(BaseBuyWeaponStrategy.class.getName());
        loggerNames.add(BaseHireCaptainForShipAboveSizeStrategy.class.getName());
        loggerNames.add(BaseHireCaptainStrategy.class.getName());
        loggerNames.add(BaseHireDismissTradeManagerStrategy.class.getName());
        loggerNames.add(BaseJoinGuildStrategy.class.getName());
        loggerNames.add(BasePlayerTradeStrategy.class.getName());
        loggerNames.add(BaseRepairStrategy.class.getName());
        loggerNames.add(BaseShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(BiggestShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(BlockadeStrategy.class.getName());
        loggerNames.add(BuyWeaponHighPirateActivityHalfSlotsFilledStrategy.class.getName());
        loggerNames.add(BuyWeaponHighPirateSuccessAllSlotsFilledStrategy.class.getName());
        loggerNames.add(BuyWeaponHighPirateSuccessHalfSlotsFilledStrategy.class.getName());
        loggerNames.add(CentralStorageDeliveryTradeStrategy.class.getName());
        loggerNames.add(CentralStorageHintContext.class.getName());
        loggerNames.add(CentralStorageStrategyHint.class.getName());
        loggerNames.add(CheapProductionTradeStrategy.class.getName());
        loggerNames.add(CollectCelebrationWaresStrategy.class.getName());
        loggerNames.add(CollectConstructionHometownCogWareStrategy.class.getName());
        loggerNames.add(CollectConstructionHometownCrayerWareStrategy.class.getName());
        loggerNames.add(CollectConstructionHometownHolkWareStrategy.class.getName());
        loggerNames.add(CollectConstructionHometownSnaikkaWareStrategy.class.getName());
        loggerNames.add(CollectConstructionTradingOfficeCogWareStrategy.class.getName());
        loggerNames.add(CollectConstructionTradingOfficeCrayerWareStrategy.class.getName());
        loggerNames.add(CollectConstructionTradingOfficeHolkWareStrategy.class.getName());
        loggerNames.add(CollectConstructionTradingOfficeSnaikkaWareStrategy.class.getName());
        loggerNames.add(CollectConstructionWareStrategy.class.getName());
        loggerNames.add(CollectConstructionWestCityCogWareStrategy.class.getName());
        loggerNames.add(CollectConstructionWestCityCrayerWareStrategy.class.getName());
        loggerNames.add(CollectConstructionWestCityHolkWareStrategy.class.getName());
        loggerNames.add(CollectConstructionWestCitySnaikkaWareStrategy.class.getName());
        loggerNames.add(CollectionConstructionHometownWaresStrategy.class.getName());
        loggerNames.add(CollectionConstructionTradingOfficeWaresStrategy.class.getName());
        loggerNames.add(CollectionConstructionWestCityWaresStrategy.class.getName());
        loggerNames.add(CollectionWaresStrategy.class.getName());
        loggerNames.add(DangerBasedShipUpgradeStrategy.class.getName());
        loggerNames.add(DefaultHireSailorsStrategy.class.getName());
        loggerNames.add(DynamicTradeRouteStrategy.class.getName());
        loggerNames.add(EightyPercentRepairStrategy.class.getName());
        loggerNames.add(FleetBasedEventDecisionStrategy.class.getName());
        loggerNames.add(HireCaptainAlwaysStrategy.class.getName());
        loggerNames.add(HireCaptainForMediumShipsStrategy.class.getName());
        loggerNames.add(HireCaptainNeverStrategy.class.getName());
        loggerNames.add(HireDismissTradeManagerMinStorageCapacityStrategy.class.getName());
        loggerNames.add(HireDismissTradeManagerStrategy.class.getName());
        loggerNames.add(HometownBiggestShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(HometownJoinGuildMinCashStrategy.class.getName());
        loggerNames.add(HometownRandomShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(HometownRepairStrategy.class.getName());
        loggerNames.add(KontorTypeCityRepairStrategy.class.getName());
        loggerNames.add(MoneyBasedEventDecisionStrategy.class.getName());
        loggerNames.add(NearHometownJoinGuildMinCashStrategy.class.getName());
        loggerNames.add(NearTradingOfficeJoinGuildMinCashStrategy.class.getName());
        loggerNames.add(OnlyTradingOfficeRepairStrategy.class.getName());
        loggerNames.add(ProductionChainTradeStrategy.class.getName());
        loggerNames.add(RandomShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(StorageBasedEventDecisionStrategy.class.getName());
        loggerNames.add(SupplyCentralTradingStationAIStrategy.class.getName());
        loggerNames.add(SupplyHometownAIStrategy.class.getName());
        loggerNames.add(TakeLoanLowMoneyLongestDurationStrategy.class.getName());
        loggerNames.add(TradeRouteTradeStrategy.class.getName());
        loggerNames.add(TradingOfficeBiggestShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(TradingOfficeJoinGuildMinCashStrategy.class.getName());
        loggerNames.add(TradingOfficeRandomShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(WestCityBiggestShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(WestCityRandomShipConstructionSelectionStrategy.class.getName());
        loggerNames.add(WestRepairStrategy.class.getName());

        // Others
        loggerNames.add(Company.class.getName());

        return loggerNames;
    }
}
