/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyCreateEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyDisolveEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyEvent;
import ch.sahits.game.openpatrician.display.EViewState;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.data.NewGameClient;
import ch.sahits.game.openpatrician.event.data.SwitchCity;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.service.IPostLoadOperation;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ClientViewState
implements IPostLoadOperation {
    @XStreamOmitField
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @ObjectPropertyType(value=EViewState.class)
    private ObjectProperty<EViewState> state = new SimpleObjectProperty((Object)EViewState.CITY);
    @OptionalType(value=ICityPlayerProxyJFX.class)
    private Optional<ICityPlayerProxyJFX> currentCityProxy = Optional.empty();
    private IHumanPlayer player;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    protected AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.logger.debug("Unregister event bus in PreDestroy");
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        this.player = newGameDTO.getPlayer();
        this.state.setValue((Object)EViewState.CITY);
        IShip activeShip = null;
        for (IShip ship : this.player.getFleet()) {
            if (!ship.isAvailable()) continue;
            activeShip = ship;
            break;
        }
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)this.context.getBean("cityPlayerProxy", new Object[]{this.player.getHometown(), this.player, activeShip});
        this.currentCityProxy = Optional.of(proxy);
        ViewStatus viewStatus = (ViewStatus)((Object)this.context.getBean(ViewStatus.class));
        this.getCurrentCityProxy().get().cityProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                viewStatus.setCity(newValue.getName());
            }
        });
    }

    @Subscribe
    public void handleSwitchToCity(SwitchCity event) {
        if (this.currentCityProxy.isPresent() && !event.getToCity().equals(this.currentCityProxy.get().getCity())) {
            ICityPlayerProxyJFX proxy = this.currentCityProxy.get();
            ICity city = event.getToCity();
            proxy.setCity(city);
            proxy.getPlayersNavalVessels().clear();
            List ships = proxy.getPlayer().findShips(city);
            proxy.getPlayersNavalVessels().addAll((Collection)ships);
        }
    }

    public EViewState getState() {
        return (EViewState)((Object)this.state.get());
    }

    public ObjectProperty<EViewState> stateProperty() {
        return this.state;
    }

    public void setState(EViewState state) {
        this.state.set((Object)state);
    }

    public void postLoad() {
        this.state.setValue((Object)EViewState.CITY);
        PlayerList players = (PlayerList)this.context.getBean(PlayerList.class);
        for (IPlayer curPlayer : players) {
            if (!(curPlayer instanceof IHumanPlayer)) continue;
            this.player = (IHumanPlayer)curPlayer;
            break;
        }
        CityPlayerProxyJFX proxy = (CityPlayerProxyJFX)this.context.getBean("cityPlayerProxy", new Object[]{this.player.getHometown(), this.player, null});
        this.currentCityProxy = Optional.of(proxy);
        proxy.postLoad();
    }

    @Subscribe
    public void handleConvoyDissolving(ConvoyDisolveEvent event) {
        this.getCurrentCityProxy().get().leave((INavigableVessel)event.getConvoy());
        IHumanPlayer player = this.getCurrentCityProxy().get().getPlayer();
        player.removeSelectableVessel((INavigableVessel)event.getConvoy());
    }

    @Subscribe
    public void handleConvoyEvent(ConvoyEvent event) {
        IShip ship = event.getShip();
        if (event.isJoining()) {
            ICityPlayerProxyJFX proxy = this.getCurrentCityProxy().get();
            proxy.leave((INavigableVessel)ship);
            proxy.getPlayer().removeSelectableVessel((INavigableVessel)ship);
        } else {
            ICityPlayerProxyJFX proxy = this.getCurrentCityProxy().get();
            proxy.arrive((INavigableVessel)ship);
            proxy.getPlayer().addSelectableVessel((INavigableVessel)ship);
        }
    }

    @Subscribe
    public void handleConvoyCreation(ConvoyCreateEvent event) {
        ICityPlayerProxyJFX proxy = this.getCurrentCityProxy().get();
        proxy.arrive((INavigableVessel)event.getConvoy());
        proxy.leave((INavigableVessel)event.getOrleg());
        proxy.activateShip((INavigableVessel)event.getConvoy());
    }

    public Optional<ICityPlayerProxyJFX> getCurrentCityProxy() {
        return this.currentCityProxy;
    }

    public IHumanPlayer getPlayer() {
        return this.player;
    }
}

