/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.service.GamePropertyUtility;
import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@ClassCategory(value={EClassCategory.STARTUP})
public class CommandLineArguments {
    public static final String VERSION_OPTION = "version";
    public static final String HELP_OPTION = "h";
    public static final String GAME_LOCALE = "l";
    private static final String WINDOWED_MODE = "w";
    private static final String FULLSCREEN_MODE = "f";
    public static final String CLIENT_OPTION = "c";
    public static final String SERVER_OPTION = "s";
    private CommandLineParser parser = new DefaultParser();
    private GamePropertyUtility gameProperties = new GamePropertyUtility();

    public Options createCommandLineOptions() {
        Options opts = new Options();
        opts.addOption(HELP_OPTION, "help", false, "Display help");
        opts.addOption(Option.builder().longOpt(VERSION_OPTION).desc("Version of this application").build());
        opts.addOption(FULLSCREEN_MODE, "fullscreen", false, "fullscreen mode");
        opts.addOption(Option.builder().argName(WINDOWED_MODE).longOpt("windowed").optionalArg(true).argName("widthxheight").desc("Windowed mode with optional definition of window size like: 1280x780").build());
        opts.addOption("disableRandomEvents", false, "Disable random events");
        opts.addOption("disableAITrading", false, "Disable AI trading");
        opts.addOption(GAME_LOCALE, "lang", true, "Specify the locale to use");
        opts.addOption(CLIENT_OPTION, "client", false, "Start application in client mode. Currently unused. Either client or server must be specified");
        opts.addOption(SERVER_OPTION, "server", false, "Start application in server mode. Currently unused. Either client or server must be specified");
        return opts;
    }

    public CommandLine parseCommandLine(Options options, String[] args) {
        try {
            return this.parser.parse(options, args);
        }
        catch (ParseException exp) {
            this.printHelp(options);
            throw new IllegalArgumentException("Parsing of command line arguments failed", exp);
        }
    }

    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("OpenPatrician", options);
    }

    public boolean isStandalone(CommandLine cmdLine) {
        return !cmdLine.hasOption(CLIENT_OPTION) && !cmdLine.hasOption(SERVER_OPTION) || cmdLine.hasOption(CLIENT_OPTION) && cmdLine.hasOption(SERVER_OPTION);
    }

    public boolean isServer(CommandLine cmdLine) {
        return !this.isStandalone(cmdLine) && cmdLine.hasOption(SERVER_OPTION);
    }

    public boolean isClient(CommandLine cmdLine) {
        return !this.isStandalone(cmdLine) && cmdLine.hasOption(CLIENT_OPTION);
    }

    public void persistAsPropertyFile(CommandLine cmdLine) {
        int height;
        Properties props = this.gameProperties.getProperties();
        if (this.isStandalone(cmdLine)) {
            this.gameProperties.addSpringProfile("standalone");
        } else if (cmdLine.hasOption(CLIENT_OPTION)) {
            this.gameProperties.addSpringProfile("client");
        } else if (cmdLine.hasOption(SERVER_OPTION)) {
            this.gameProperties.addSpringProfile("server");
        }
        if (cmdLine.hasOption(FULLSCREEN_MODE)) {
            props.setProperty("window.fullscreen", "true");
        } else {
            props.setProperty("window.fullscreen", "false");
        }
        if (cmdLine.hasOption(WINDOWED_MODE)) {
            props.setProperty("window.fullscreen", "false");
            String windowedOption = cmdLine.getOptionValue(WINDOWED_MODE);
            if (windowedOption != null) {
                String[] values = windowedOption.split("x");
                try {
                    Integer.parseInt(values[0]);
                    Integer.parseInt(values[1]);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("The window size parameter is invalid: " + windowedOption);
                }
                props.setProperty("window.width", values[0]);
                props.setProperty("window.height", values[1]);
            }
        }
        if (props.get("window.height") == null) {
            height = 766;
            props.setProperty("window.height", String.valueOf(height));
        } else {
            height = Integer.parseInt((String)props.get("window.height"));
        }
        this.checkMinimalHeight(height);
        if (cmdLine.hasOption(GAME_LOCALE)) {
            props.setProperty("game.locale", cmdLine.getOptionValue(GAME_LOCALE));
        }
        if (cmdLine.hasOption("disableRandomEvents")) {
            System.setProperty("disableRandomEvents", "true");
        }
        if (cmdLine.hasOption("disableAITrading")) {
            System.setProperty("disableAITrading", "true");
        }
        this.gameProperties.persistProperties();
    }

    private void checkMinimalHeight(int height) {
        Preconditions.checkArgument((height >= 766 ? 1 : 0) != 0, (Object)"The frame in the display must have at least 766px height");
    }
}

