/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ui.ButtonTemplate;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.PROTOTYPE_BEAN, EClassCategory.DIALOG})
public class GenericCloseButtonDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(GenericCloseButtonDialog.class);
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    private final DialogTemplate template;
    private StyleableObjectProperty<Font> font;

    public GenericCloseButtonDialog(DialogTemplate template) {
        this.template = template;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage(this.template.getTitleKey(), this.template.getMessageArgs(), this.locale.getCurrentLocal()));
        String s = this.messageSource.getMessage(this.template.getMessageKey(), this.template.getMessageArgs(), this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(s, new HashMap());
        this.getContent().add((Object)text);
        if (this.template.getButtons() != null && !this.template.getButtons().isEmpty()) {
            HBox box = new HBox(8.0);
            for (ButtonTemplate buttonTemplate : this.template.getButtons()) {
                OpenPatricianLargeWaxButton btn;
                s = this.messageSource.getMessage(buttonTemplate.getLabelKey(), this.template.getMessageArgs(), this.locale.getCurrentLocal());
                if (buttonTemplate.isLargeButton()) {
                    btn = new OpenPatricianLargeWaxButton(s);
                    btn.getStyleClass().add((Object)"actionButton");
                    btn.setOnAction(evt -> {
                        try {
                            buttonTemplate.getAction().run();
                        }
                        catch (RuntimeException e) {
                            log.error("Failed to execute action", (Throwable)e);
                        }
                    });
                    box.getChildren().add((Object)btn);
                    continue;
                }
                btn = new OpenPatricianSmallWaxButton(s);
                btn.getStyleClass().add((Object)"actionButton");
                btn.setOnAction(evt -> {
                    try {
                        buttonTemplate.getAction().run();
                    }
                    catch (RuntimeException e) {
                        log.error("Failed to execute action", (Throwable)e);
                    }
                });
                box.getChildren().add((Object)btn);
            }
            box.setLayoutY(603.0);
            box.setLayoutX((518.0 - box.getWidth()) / 2.0);
            this.getContent().add((Object)box);
        }
        this.getCloseButton().setVisible(this.template.isClosable());
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return GenericCloseButtonDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<GenericCloseButtonDialog, Font> FONT = new CssMetaData<GenericCloseButtonDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(GenericCloseButtonDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(GenericCloseButtonDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

