/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.CityFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.MapUpdateCityAdd;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IBuildLandPassage;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ICustomsViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IFoundNewSettlement;
import ch.sahits.game.openpatrician.model.city.cityhall.IHelpCity;
import ch.sahits.game.openpatrician.model.city.cityhall.IHuntPirate;
import ch.sahits.game.openpatrician.model.city.cityhall.IPirateSupportViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IPlunderTradingOfficesViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.BuildLandPassage;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.FoundNewSettlement;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.HelpCity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.sea.PirateNest;
import ch.sahits.game.openpatrician.model.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class AldermanOfficeDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(AldermanOfficeDialog.class);
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelStateAccessor cityHallProvider;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private IMap map;
    @Autowired
    private Date date;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapLocationDetectionModel mapLocationDetectionModel;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private MapService mapService;
    @Autowired
    private ModelTranslations modelTranslator;
    private final IntegerProperty currentIndex = new SimpleIntegerProperty(0);
    private final ICityPlayerProxyJFX city;
    @ListType(value=IAldermanTask.class)
    private final List<IAldermanTask> tasks = new ArrayList<IAldermanTask>();
    private VBox content;
    private StyleableObjectProperty<Font> font;

    public AldermanOfficeDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        ICityHall cityHall = this.cityHallProvider.getCityHall(this.city.getCity());
        AldermanOffice aldermanOffice = (AldermanOffice)cityHall.getAldermanOffice().get();
        this.tasks.addAll((Collection<IAldermanTask>)aldermanOffice.getTasks());
        int actionButtonX = 197;
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.aldermanOffice", new Object[0], this.locale.getCurrentLocal()));
        this.content = new VBox(24.0);
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskSelection", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        DecoratedText decoratedTask = this.createCurrentTask();
        HBox navigationBar = new HBox(15.0);
        OpenPatricianSmallWaxButton back = new OpenPatricianSmallWaxButton("<");
        back.getStyleClass().add((Object)"actionButton");
        back.setId("back");
        back.setOnAction(this.createPreviousAction());
        OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
        next.getStyleClass().add((Object)"actionButton");
        next.setId("next");
        next.setOnAction(this.createNextAction());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        action.getStyleClass().add((Object)"actionButton");
        action.setId("action");
        action.setOnAction(this.createAction(this.tasks.get(this.currentIndex.get()), aldermanOffice));
        navigationBar.getChildren().addAll((Object[])new Node[]{back, action, next});
        navigationBar.setLayoutX((518.0 - navigationBar.getWidth()) / 2.0);
        navigationBar.widthProperty().addListener((observable, oldWidth, newWidth) -> navigationBar.setLayoutX((518.0 - newWidth.doubleValue()) / 2.0));
        navigationBar.setLayoutY(563.0);
        this.content.getChildren().addAll((Object[])new Node[]{text, decoratedTask});
        OpenPatricianLargeWaxButton meetings = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.meetings", new Object[0], this.locale.getCurrentLocal()));
        meetings.getStyleClass().add((Object)"actionButton");
        meetings.setId("meetings");
        meetings.setOnAction(this.createMeetingsAction());
        meetings.setLayoutX(197.0);
        meetings.setLayoutY(603.0);
        if (this.city.getPlayer().getRank() != ESocialRank.ALDERMAN) {
            meetings.setVisible(false);
        }
        this.content.setLayoutY(text.getLayoutY());
        this.content.setLayoutX(text.getLayoutX());
        this.getContent().addAll((Object[])new Node[]{this.content, navigationBar, meetings});
    }

    private EventHandler<MouseEvent> createMeetingsAction() {
        return mouseEvent -> {
            try {
                CityHall cityHall = (CityHall)this.cityHallProvider.getCityHall(this.city.getCity());
                AldermanOffice office = (AldermanOffice)cityHall.getAldermanOffice().get();
                this.getContent().clear();
                if (!office.getViolation().isPresent()) {
                    String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.noViolations", new Object[0], this.locale.getCurrentLocal());
                    DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                    this.getContent().add((Object)text);
                } else {
                    DecoratedText text;
                    String template;
                    ICityViolation violation = (ICityViolation)office.getViolation().get();
                    VBox box = new VBox();
                    if (violation instanceof ICustomsViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.customViolation", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                    } else if (violation instanceof IPirateSupportViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.pirateSupport", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                    } else if (violation instanceof IPlunderTradingOfficesViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.plunderOffice", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                    } else if (violation instanceof ISpecialTaxViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.specialTaxViolation", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                    } else {
                        throw new IllegalStateException("Unhandled violation type: " + violation.getClass().getName());
                    }
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.measureSelection", new Object[0], this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    box.setLayoutY(text.getLayoutY());
                    box.setLayoutX(text.getLayoutX());
                    box.getChildren().add((Object)text);
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.noPunishment", new Object[0], this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    text.setId("noPunishment");
                    text.setOnMouseReleased(evt -> {
                        office.setViolation(Optional.empty());
                        DialogTemplate dialogTemplate = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.displeasure.title").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.displeasure").messageArgs(new Object[]{violation.getCity().getName()}).build();
                        this.taskFactory.getPostponedDisplayDialogMessage(violation.getDate(), EMessageCategory.OFFICIAL, dialogTemplate);
                        this.executeOnCloseButtonClicked();
                    });
                    box.getChildren().add((Object)text);
                    ITreasury otherTreasury = this.cityHallProvider.getCityHall(violation.getCity()).getTreasury();
                    int fine = (int)(otherTreasury.getCash() / 100L);
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.smallFine", new Object[]{fine}, this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    text.setId("smallFine");
                    text.setOnMouseReleased(evt -> {
                        ((CityViolation)violation).setPunishment(ECityViolationPunishment.SMALL_FINE);
                        LocalDateTime when = this.date.getCurrentDate().plusMonths(2L);
                        cityHall.setHanseaticMeetingDate(Optional.of(when));
                        this.executeOnCloseButtonClicked();
                    });
                    box.getChildren().add((Object)text);
                    fine = (int)(otherTreasury.getCash() / 10L);
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.mediumFine", new Object[]{fine}, this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    text.setId("mediumFine");
                    text.setOnMouseReleased(evt -> {
                        ((CityViolation)violation).setPunishment(ECityViolationPunishment.MEDIUM_FINE);
                        LocalDateTime when = this.date.getCurrentDate().plusMonths(2L);
                        cityHall.setHanseaticMeetingDate(Optional.of(when));
                        this.executeOnCloseButtonClicked();
                    });
                    box.getChildren().add((Object)text);
                    fine = (int)((double)otherTreasury.getCash() * 0.9);
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.largeFine", new Object[]{fine}, this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    text.setId("largeFine");
                    text.setOnMouseReleased(evt -> {
                        ((CityViolation)violation).setPunishment(ECityViolationPunishment.LARGE_FINE);
                        LocalDateTime when = this.date.getCurrentDate().plusMonths(2L);
                        cityHall.setHanseaticMeetingDate(Optional.of(when));
                        this.executeOnCloseButtonClicked();
                    });
                    box.getChildren().add((Object)text);
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.boycott", new Object[]{fine}, this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    text.setId("boycott");
                    text.setOnMouseReleased(evt -> {
                        ((CityViolation)violation).setPunishment(ECityViolationPunishment.BLOCKADE);
                        LocalDateTime when = this.date.getCurrentDate().plusMonths(2L);
                        cityHall.setHanseaticMeetingDate(Optional.of(when));
                        this.executeOnCloseButtonClicked();
                    });
                    box.getChildren().add((Object)text);
                    this.getContent().addAll((Object[])new Node[]{box});
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to define meetings action", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createAction(IAldermanTask task, AldermanOffice office) {
        return mouseEvent -> {
            try {
                DialogTemplate template;
                Object[] args;
                LocalDateTime deadline;
                BuildLandPassage concreteTask;
                if (task instanceof IBuildLandPassage) {
                    concreteTask = (BuildLandPassage)task;
                    deadline = this.date.getCurrentDate().plusDays(concreteTask.getDuration());
                    args = new Object[]{concreteTask.getFromCity().getName(), concreteTask.getToCity().getName(), this.modelTranslator.toDisplayString(deadline)};
                    template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.buildLandPassageTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.buildLandPassageParagraph").messageArgs(args).build();
                    this.taskFactory.getPostponedDisplayDialogMessage(this.date.getCurrentDate().plusHours(18L), EMessageCategory.OFFICIAL, template);
                    office.addTask(task, deadline, (IPlayer)this.city.getPlayer());
                }
                if (task instanceof IFoundNewSettlement) {
                    concreteTask = (FoundNewSettlement)task;
                    deadline = this.date.getCurrentDate().plusDays(concreteTask.getDuration());
                    args = new Object[]{concreteTask.getName(), this.modelTranslator.toDisplayString(deadline)};
                    template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.foundNewSettlementTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.foundNewSettlementParagraph").messageArgs(args).build();
                    this.taskFactory.getPostponedDisplayDialogMessage(this.date.getCurrentDate().plusHours(18L), EMessageCategory.OFFICIAL, template);
                    ICity foundingTown = this.cityFactory.createFutureCity((FoundNewSettlement)concreteTask);
                    this.mapService.buildSettlement(foundingTown, (IPlayer)this.city.getPlayer());
                    this.clientEventBus.post((Object)new MapUpdateCityAdd(foundingTown, (IPlayer)this.city.getPlayer()));
                    office.addTask(task, deadline, (IPlayer)this.city.getPlayer());
                }
                if (task instanceof IHelpCity) {
                    concreteTask = (HelpCity)task;
                    deadline = this.date.getCurrentDate().plusDays(concreteTask.getDuration());
                    args = new Object[]{this.modelTranslator.toDisplayString(deadline), concreteTask.getCity().getName()};
                    template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.helpCityTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.helpCityParagraph").messageArgs(args).build();
                    this.taskFactory.getPostponedDisplayDialogMessage(this.date.getCurrentDate().plusHours(18L), EMessageCategory.OFFICIAL, template);
                    office.addTask(task, deadline, (IPlayer)this.city.getPlayer());
                }
                if (task instanceof IHuntPirate) {
                    concreteTask = (IHuntPirate)task;
                    deadline = this.date.getCurrentDate().plusDays(concreteTask.getDuration());
                    args = new Object[]{concreteTask.getPirate().getName(), this.modelTranslator.toDisplayString(deadline)};
                    template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.huntPirateTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.huntPirateParagraph").messageArgs(args).build();
                    this.taskFactory.getPostponedDisplayDialogMessage(this.date.getCurrentDate().plusHours(18L), EMessageCategory.OFFICIAL, template);
                    office.addTask(task, deadline, (IPlayer)this.city.getPlayer());
                }
                if (task instanceof ICapturePirateNest) {
                    concreteTask = (CapturePirateNest)task;
                    deadline = this.date.getCurrentDate().plusDays(concreteTask.getDuration());
                    args = new Object[]{this.modelTranslator.toDisplayString(deadline), concreteTask.getPirateNestMap().getImageName()};
                    template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.destroyPiratesNestTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.destroyPiratesNestParagraph").messageArgs(args).build();
                    this.taskFactory.getPostponedDisplayDialogMessage(this.date.getCurrentDate().plusHours(18L), EMessageCategory.OFFICIAL, template);
                    office.addTask(task, deadline, (IPlayer)this.city.getPlayer());
                    PirateNest nest = new PirateNest(concreteTask.getLocation());
                    this.map.getPirateNests().add(nest);
                    this.mapLocationDetectionModel.addSegment((MapSegmentedImage)concreteTask.getPirateNestMap());
                }
                this.cityHallProvider.assignTask((IPlayer)this.city.getPlayer(), task);
                office.getTasks().remove((Object)task);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to schedule task", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createNextAction() {
        return mouseEvent -> {
            try {
                if (this.currentIndex.get() == this.tasks.size() - 1) {
                    this.currentIndex.set(0);
                } else {
                    this.currentIndex.set(this.currentIndex.get() + 1);
                }
                this.content.getChildren().remove(1);
                this.content.getChildren().add(1, (Object)this.createCurrentTask());
            }
            catch (RuntimeException e) {
                log.error("Failed to switch to next task", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createPreviousAction() {
        return mouseEvent -> {
            try {
                if (this.currentIndex.get() == 0) {
                    this.currentIndex.set(this.tasks.size() - 1);
                } else {
                    this.currentIndex.set(this.currentIndex.get() - 1);
                }
                this.content.getChildren().remove(1);
                this.content.getChildren().add(1, (Object)this.createCurrentTask());
            }
            catch (RuntimeException e) {
                log.error("Failed to switch to previous task", (Throwable)e);
            }
        };
    }

    private DecoratedText createCurrentTask() {
        IAldermanTask task = this.tasks.get(this.currentIndex.get());
        if (task instanceof IBuildLandPassage) {
            IBuildLandPassage passage = (IBuildLandPassage)task;
            double width = this.map.getDimension().getWidth();
            double heigth = this.map.getDimension().getHeight();
            String orientation = this.messageSource.getMessage("orientation.west", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            if (passage.getFromCity().getCoordinates().getY() < heigth / 2.0) {
                orientation = this.messageSource.getMessage("orientation.north", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            }
            if (passage.getFromCity().getCoordinates().getX() > width / 2.0) {
                orientation = this.messageSource.getMessage("orientation.east", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            }
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskNewPassage", new Object[]{orientation}, this.locale.getCurrentLocal());
            return this.textFactory.createDecoratedText(template, new HashMap());
        }
        if (task instanceof ICapturePirateNest) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskPirateNest", new Object[0], this.locale.getCurrentLocal());
            return this.textFactory.createDecoratedText(template, new HashMap());
        }
        if (task instanceof IFoundNewSettlement) {
            IFoundNewSettlement newSettlement = (IFoundNewSettlement)task;
            double width = this.map.getDimension().getWidth();
            double heigth = this.map.getDimension().getHeight();
            String orientation = this.messageSource.getMessage("orientation.west", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            if (newSettlement.getLocation().getY() < heigth / 2.0) {
                orientation = this.messageSource.getMessage("orientation.north", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            }
            if (newSettlement.getLocation().getX() > width / 2.0) {
                orientation = this.messageSource.getMessage("orientation.east", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            }
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskNewTown", new Object[]{orientation}, this.locale.getCurrentLocal());
            return this.textFactory.createDecoratedText(template, new HashMap());
        }
        if (task instanceof IHelpCity) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskHelpCity", new Object[0], this.locale.getCurrentLocal());
            return this.textFactory.createDecoratedText(template, new HashMap());
        }
        if (task instanceof IHuntPirate) {
            IHuntPirate pirateTask = (IHuntPirate)task;
            String name = pirateTask.getPirate().getName();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.taskPirateHunt", new Object[]{name}, this.locale.getCurrentLocal());
            return this.textFactory.createDecoratedText(template, new HashMap());
        }
        throw new IllegalStateException("Unknown task type: " + task.getClass().getName());
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_ALDERMAN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AldermanOfficeDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<AldermanOfficeDialog, Font> FONT = new CssMetaData<AldermanOfficeDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(AldermanOfficeDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(AldermanOfficeDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

