/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.loaner;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerTakeLoanDialog
extends DefaultSimpleDialog {
    private static final Logger log = LoggerFactory.getLogger(LoanerTakeLoanDialog.class);
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private LoanerService loanerService;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=ILoanProposal.class)
    private ObjectProperty<ILoanProposal> selectedProposal = new SimpleObjectProperty(null);
    @ListType(value=Node.class)
    private List<Node> loans = new ArrayList<Node>();

    public LoanerTakeLoanDialog(ICityPlayerProxyJFX city) {
        super(false);
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerService.findLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.takeLoan", new Object[0], this.locale.getCurrentLocal()));
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerTakeLoanDialog.dialogSubheading", "introText", new Object[0]);
        for (ILoanProposal proposal : this.loaner.getLoanProposals()) {
            int amount = proposal.getAmount();
            int payback = (int)((double)amount * proposal.getInterest());
            int duration = proposal.getDurationInWeeks();
            String interest = String.format("%.1f", (proposal.getInterest() - 1.0) * 100.0);
            DecoratedText entry = this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerTakeLoanDialog.loanProposal", "proposal", amount, duration, payback, interest);
            this.loans.add((Node)entry);
            entry.setOnMouseReleased(mouseEvent -> {
                this.selectedProposal.setValue((Object)proposal);
                this.deactivateAll();
                entry.applyStyle(SELECTED_STYLE);
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
        OpenPatricianLargeWaxButton acceptBtn = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.LoanerTakeLoanDialog.btnLabel", "actionBtn");
        acceptBtn.setDisable(true);
        this.selectedProposal.addListener((observableValue, oldProposal, newProposal) -> {
            if (newProposal != null) {
                acceptBtn.setDisable(false);
            }
        });
        acceptBtn.setOnAction(this.createAcceptHandler());
    }

    private void deactivateAll() {
        for (Node node : this.loans) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                ILoanProposal proposal = (ILoanProposal)this.selectedProposal.get();
                IHumanPlayer debitor = this.city.getPlayer();
                this.loanerService.takeOutLoan((ILoaner)this.loaner, proposal, (IPlayer)debitor, this.city.getCity());
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to take loan", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

