/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.ship;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.EViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.dialog.ship.ShipModelForShipList;
import ch.sahits.game.openpatrician.display.event.data.FocusLocationEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.SwitchCity;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.MapState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipListDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX proxy;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private IDataImageLoader imageLoader;
    @Autowired
    private ModelTranslations translations;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MapState mapState;
    @Autowired
    private ShipService shipService;
    @Autowired
    private DialogUtil dialogUtil;
    private Image anchor;
    private Image sail;
    private Image repair;
    private Image coin0;
    private Image coin1;
    private Image coin2;
    private Image coin3;
    private Image coin4;
    private Image coin5;
    private Image convoy;
    private Image autotrade;

    public ShipListDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
        String cssFileName = "ScrollPane.css";
        URL resource = NoticeBoard.class.getResource(cssFileName);
        this.getStylesheets().add((Object)resource.toExternalForm());
    }

    @PostConstruct
    private void initializeDialog() {
        RowConstraints rowConstraints = new RowConstraints(32.0);
        this.anchor = this.imageLoader.getImage("icons/32/anchor");
        this.sail = this.imageLoader.getImage("icons/32/sailing-icon");
        this.repair = this.imageLoader.getImage("icons/32/repair-icon");
        this.coin0 = this.imageLoader.getImage("icons/32/coins-0-icon");
        this.coin1 = this.imageLoader.getImage("icons/32/coins-1-icon");
        this.coin2 = this.imageLoader.getImage("icons/32/coins-2-icon");
        this.coin3 = this.imageLoader.getImage("icons/32/coins-3-icon");
        this.coin4 = this.imageLoader.getImage("icons/32/coins-4-icon");
        this.coin5 = this.imageLoader.getImage("icons/32/coins-5-icon");
        this.convoy = this.imageLoader.getImage("icons/32/icon_convoy");
        this.autotrade = this.imageLoader.getImage("icons/32/icon_autotrade");
        GridPane header = new GridPane();
        header.setId("header");
        header.setLayoutY(100.0);
        header.setLayoutX(30.0);
        String shipName = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipListDialog.shipname", new Object[0], this.locale.getCurrentLocal());
        Label shipNameTitle = new Label(shipName);
        shipNameTitle.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        header.add((Node)shipNameTitle, 0, 0);
        GridPane.setValignment((Node)shipNameTitle, (VPos)VPos.CENTER);
        header.getRowConstraints().add((Object)rowConstraints);
        int iconWidth = 32;
        int col2Width = 70;
        int col3Width = 100;
        int col1Width = 458 - col2Width - col3Width - iconWidth * 6;
        header.getColumnConstraints().add((Object)new ColumnConstraints((double)col1Width));
        Label shipTypeTitle = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipListDialog.shiptype", new Object[0], this.locale.getCurrentLocal()));
        shipTypeTitle.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        header.add((Node)shipTypeTitle, 1, 0);
        GridPane.setValignment((Node)shipTypeTitle, (VPos)VPos.CENTER);
        header.getColumnConstraints().add((Object)new ColumnConstraints((double)col2Width));
        Label shipStateTitle = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipListDialog.shipstate", new Object[0], this.locale.getCurrentLocal()));
        shipStateTitle.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        header.add((Node)shipStateTitle, 2, 0);
        GridPane.setValignment((Node)shipStateTitle, (VPos)VPos.CENTER);
        header.getColumnConstraints().add((Object)new ColumnConstraints((double)col3Width));
        Image img = this.imageLoader.getImage("icons/32/health-icon");
        ImageView healthIcon = new ImageView(img);
        header.add((Node)healthIcon, 3, 0);
        GridPane.setValignment((Node)healthIcon, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)healthIcon, (HPos)HPos.CENTER);
        header.getColumnConstraints().add((Object)new ColumnConstraints(img.getWidth()));
        img = this.imageLoader.getImage("icons/32/cargo-capacity-icon");
        ImageView capacityIcon = new ImageView(img);
        header.add((Node)capacityIcon, 4, 0);
        GridPane.setValignment((Node)capacityIcon, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)capacityIcon, (HPos)HPos.CENTER);
        header.getColumnConstraints().add((Object)new ColumnConstraints(img.getWidth()));
        img = this.imageLoader.getImage("icons/32/trade-icon");
        ImageView valueIcon = new ImageView(img);
        header.add((Node)valueIcon, 5, 0);
        GridPane.setValignment((Node)valueIcon, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)valueIcon, (HPos)HPos.CENTER);
        header.getColumnConstraints().add((Object)new ColumnConstraints(img.getWidth() * 2.0));
        Label emptyLbl = new Label("");
        header.add((Node)emptyLbl, 6, 0);
        header.getColumnConstraints().add((Object)new ColumnConstraints(img.getWidth() * 2.0));
        GridPane body = new GridPane();
        body.setId("body");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setLayoutX(29.0);
        scrollPane.setLayoutY((double)(100 + iconWidth));
        scrollPane.setMaxWidth(488.0);
        scrollPane.setMinWidth(488.0);
        scrollPane.setMaxHeight(491.0);
        scrollPane.setMinHeight(491.0);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setContent((Node)body);
        ObservableList<ShipModelForShipList> shipList = this.createObservableList();
        int row = 0;
        for (ShipModelForShipList shipModelForShipList : shipList) {
            boolean selectable = this.isSelectableShip(shipModelForShipList);
            Label name = new Label(shipModelForShipList.getShipName());
            name.getStyleClass().add((Object)"smallDialogText");
            name.setId("name" + row);
            if (!selectable) {
                name.getStyleClass().add((Object)"inactive");
            } else {
                name.setOnMouseReleased(event -> {
                    IShip ship = shipModelForShipList.getShip();
                    this.proxy.activateShip((INavigableVessel)ship);
                    switch ((EShipTravelState)shipModelForShipList.travelingState().get()) {
                        case TRAVEL_TO_CITY: 
                        case TRAVEL_TO_DESTINATION: {
                            ViewChangeCityPlayerProxyJFX proxy;
                            if (this.viewState.getState() != EViewState.MAP) {
                                this.mapState.setShowingLargeSeaMap(true);
                                proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_SEA_MAP);
                                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                            }
                            this.clientEventBus.post((Object)new FocusLocationEvent(ship.getLocation()));
                            proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                            this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                            this.executeOnCloseButtonClicked();
                            break;
                        }
                        case ANCHOR: 
                        case REPAIR: {
                            Optional optCity = this.shipService.findCity((INavigableVessel)ship);
                            Preconditions.checkArgument((boolean)optCity.isPresent(), (Object)("Ship " + ship.getUuid() + " with state " + ship.travelState().get() + " is not in a city."));
                            if (!this.proxy.getCity().equals(optCity.get()) || this.viewState.getState() == EViewState.MAP) {
                                this.clientEventBus.post((Object)new SwitchCity((ICity)optCity.get()));
                            }
                            this.executeOnCloseButtonClicked();
                            break;
                        }
                    }
                });
            }
            body.add((Node)name, 0, row);
            body.getRowConstraints().add((Object)rowConstraints);
            GridPane.setValignment((Node)name, (VPos)VPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints((double)col1Width));
            Label type = new Label(this.translations.getLocalDisplayName(shipModelForShipList.getShipType()));
            type.getStyleClass().add((Object)"smallDialogText");
            if (!selectable) {
                type.getStyleClass().add((Object)"inactive");
            }
            body.add((Node)type, 1, row);
            GridPane.setValignment((Node)type, (VPos)VPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints((double)col2Width));
            ImageView statusIcon = new ImageView(this.dialogUtil.getStatusIcon((EShipTravelState)shipModelForShipList.travelingState().get()));
            shipModelForShipList.travelingState().addListener((state, oldValue, newvalue) -> statusIcon.setImage(this.dialogUtil.getStatusIcon((EShipTravelState)shipModelForShipList.travelingState().get())));
            body.add((Node)statusIcon, 2, row);
            GridPane.setValignment((Node)statusIcon, (VPos)VPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints(statusIcon.getImage().getWidth()));
            Label destination = new Label(shipModelForShipList.destination().get());
            shipModelForShipList.destination().addListener((dest, odlValue, newValue) -> destination.setText(newValue));
            destination.getStyleClass().add((Object)"smallDialogText");
            if (!selectable) {
                destination.getStyleClass().add((Object)"inactive");
            }
            body.add((Node)destination, 3, row);
            GridPane.setValignment((Node)destination, (VPos)VPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints((double)(col3Width - iconWidth)));
            Label health = new Label(String.valueOf(shipModelForShipList.getHealth()));
            health.getStyleClass().add((Object)"smallDialogText");
            if (!selectable) {
                health.getStyleClass().add((Object)"inactive");
            }
            body.add((Node)health, 4, row);
            GridPane.setValignment((Node)destination, (VPos)VPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints((double)iconWidth));
            Label loadedCapacity = new Label(String.valueOf(shipModelForShipList.loadedWares().get()));
            loadedCapacity.getStyleClass().add((Object)"smallDialogText");
            if (!selectable) {
                loadedCapacity.getStyleClass().add((Object)"inactive");
            }
            body.add((Node)loadedCapacity, 5, row);
            GridPane.setValignment((Node)loadedCapacity, (VPos)VPos.CENTER);
            GridPane.setHalignment((Node)loadedCapacity, (HPos)HPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints((double)iconWidth));
            ImageView value = new ImageView(this.getCargoValue(shipModelForShipList));
            shipModelForShipList.loadedWares().addListener((loaded, oldValue, newValue) -> {
                loadedCapacity.setText(String.valueOf(newValue));
                value.setImage(this.getCargoValue(shipModelForShipList));
            });
            body.add((Node)value, 6, row);
            GridPane.setValignment((Node)value, (VPos)VPos.CENTER);
            GridPane.setHalignment((Node)value, (HPos)HPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints(value.getImage().getWidth()));
            ImageView convoyIcon = shipModelForShipList.getParent().isPresent() ? new ImageView(this.convoy) : new ImageView(this.sail);
            body.add((Node)convoyIcon, 7, row);
            GridPane.setValignment((Node)convoyIcon, (VPos)VPos.CENTER);
            GridPane.setHalignment((Node)convoyIcon, (HPos)HPos.CENTER);
            body.getColumnConstraints().add((Object)new ColumnConstraints(convoyIcon.getImage().getWidth()));
            if (shipModelForShipList.isAutotrading()) {
                ImageView autoTrading = new ImageView(this.autotrade);
                body.add((Node)autoTrading, 8, row);
                GridPane.setValignment((Node)convoyIcon, (VPos)VPos.CENTER);
                GridPane.setHalignment((Node)convoyIcon, (HPos)HPos.CENTER);
                body.getColumnConstraints().add((Object)new ColumnConstraints(this.autotrade.getWidth()));
            }
            ++row;
        }
        this.getContent().addAll((Object[])new Node[]{header, scrollPane});
    }

    private boolean isSelectableShip(ShipModelForShipList shipModelForShipList) {
        return shipModelForShipList.isPlayersShip(this.proxy.getPlayer()) && !((EShipTravelState)shipModelForShipList.travelingState().get()).equals((Object)EShipTravelState.EXPEDITION) && shipModelForShipList.getShip().isAvailable();
    }

    private Image getCargoValue(ShipModelForShipList shipModelForShipList) {
        int value = shipModelForShipList.getValue();
        if (value < 1000) {
            return this.coin0;
        }
        if (value < 2000) {
            return this.coin1;
        }
        if (value < 4000) {
            return this.coin2;
        }
        if (value < 8000) {
            return this.coin3;
        }
        if (value < 16000) {
            return this.coin4;
        }
        return this.coin5;
    }

    @VisibleForTesting
    ObservableList<ShipModelForShipList> createObservableList() {
        IHumanPlayer player = this.proxy.getPlayer();
        ArrayList ships = new ArrayList(player.getFleet());
        ArrayList<ShipModelForShipList> sorted = new ArrayList<ShipModelForShipList>();
        while (!ships.isEmpty()) {
            IShip ship = (IShip)ships.get(0);
            if (ship.parentShipProperty().get() == null) {
                sorted.add((ShipModelForShipList)this.context.getBean(ShipModelForShipList.class, new Object[]{ship}));
                ships.remove(ship);
                continue;
            }
            IShip parent = (IShip)ship.parentShipProperty().get();
            sorted.add((ShipModelForShipList)this.context.getBean(ShipModelForShipList.class, new Object[]{parent}));
            ships.remove(parent);
            Iterator iterator = ships.iterator();
            while (iterator.hasNext()) {
                IShip s = (IShip)iterator.next();
                if (!parent.equals(s.parentShipProperty().get())) continue;
                sorted.add((ShipModelForShipList)this.context.getBean(ShipModelForShipList.class, new Object[]{s}));
                iterator.remove();
            }
        }
        return FXCollections.observableArrayList(sorted);
    }
}

