/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.IDialogCentralButton;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class TavernBaseSideRoomPersonDialog
extends CloseButtonDialog
implements IDialogCentralButton {
    private static final Logger log = LoggerFactory.getLogger(TavernBaseSideRoomPersonDialog.class);
    protected final ICityPlayerProxyJFX city;
    private final TavernState tavernState;
    protected final ObjectProperty<ISideRoomPerson> currentPerson;
    @Autowired
    protected Date date;
    @Autowired
    protected TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    protected Locale locale;
    @Autowired
    protected MessageSource messageSource;
    private OpenPatricianLargeWaxButton acceptBtn;

    public TavernBaseSideRoomPersonDialog(ICityPlayerProxyJFX city, ISideRoomPerson person) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.currentPerson = new SimpleObjectProperty((Object)this, "currentPerson", (Object)person);
    }

    protected final void initializeButtons() {
        final BooleanBinding hasMorePersons = this.hasNextPersonBinding();
        this.acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        this.acceptBtn.getStyleClass().add((Object)"actionButton");
        this.acceptBtn.setLayoutX(197.0);
        this.acceptBtn.setOnAction(this.createAcceptHandler());
        OpenPatricianLargeWaxButton nextBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.next", new Object[0], this.locale.getCurrentLocal()));
        nextBtn.getStyleClass().add((Object)"actionButton");
        nextBtn.setLayoutX(197.0);
        nextBtn.setLayoutY(603.0);
        nextBtn.setOnAction(this.createNextPersonHandler());
        nextBtn.visibleProperty().bind((ObservableValue)hasMorePersons);
        this.acceptBtn.layoutYProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{hasMorePersons});
            }

            protected double computeValue() {
                if (hasMorePersons.get()) {
                    return 579.0;
                }
                return 603.0;
            }
        });
        BooleanBinding disableAcceptButton = this.disableAcceptButton();
        this.acceptBtn.setDisable(disableAcceptButton.get());
        disableAcceptButton.addListener((observableValue, oldValue, newValue) -> this.acceptBtn.setDisable(newValue.booleanValue()));
        this.getContent().addAll((Object[])new Node[]{nextBtn, this.acceptBtn});
    }

    protected void removeAcceptButton() {
        Platform.runLater(() -> this.getContent().remove((Object)this.acceptBtn));
    }

    protected abstract EventHandler<MouseEvent> createAcceptHandler();

    private EventHandler<MouseEvent> createNextPersonHandler() {
        return mouseEvent -> {
            try {
                ((ObservableMap)this.tavernState.talkingToProperty().get()).remove(this.currentPerson.get());
                List persons = (List)this.tavernState.presentPersonsInSideRoomBinding().get();
                for (int i = 0; i < persons.size(); ++i) {
                    ISideRoomPerson person = (ISideRoomPerson)persons.get(i);
                    if (!person.equals(this.currentPerson.get())) continue;
                    if (i == persons.size() - 1) {
                        this.currentPerson.set((Object)((ISideRoomPerson)persons.get(0)));
                        break;
                    }
                    this.currentPerson.set((Object)((ISideRoomPerson)persons.get(i + 1)));
                    break;
                }
                ((ObservableMap)this.tavernState.talkingToProperty().get()).put((Object)((IPerson)this.currentPerson.get()), (Object)this.city.getPlayer());
                EDialogType nextPerson = this.map((ISideRoomPerson)this.currentPerson.get());
                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)nextPerson));
            }
            catch (RuntimeException e) {
                log.error("Failed to switch to next person", (Throwable)e);
            }
        };
    }

    private BooleanBinding hasNextPersonBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return ((List)TavernBaseSideRoomPersonDialog.this.tavernState.presentPersonsInSideRoomBinding().get()).size() > 1;
            }
        };
    }

    private EDialogType map(ISideRoomPerson person) {
        if (person instanceof ITransportTrader) {
            return EDialogType.TAVERN_TRANSPORT_TRADER;
        }
        if (person instanceof IBuyer) {
            return EDialogType.TAVERN_BUYER;
        }
        if (person instanceof IEscorte) {
            return EDialogType.TAVERN_ESCORTE;
        }
        if (person instanceof IFugitive) {
            return EDialogType.TAVERN_FUGATIVE;
        }
        if (person instanceof ICourier) {
            return EDialogType.TAVERN_COURIER;
        }
        if (person instanceof IPatrol) {
            return EDialogType.TAVERN_PATROL;
        }
        if (person instanceof IThieve) {
            return EDialogType.TAVERN_BURGLAR;
        }
        if (person instanceof IConcurrent) {
            return EDialogType.TAVERN_CONCURRENT;
        }
        if (person instanceof IPirateHunter) {
            return EDialogType.TAVERN_PIRATE_HUNTER;
        }
        if (person instanceof IWarehouseTenant) {
            return EDialogType.TAVERN_WAREHOUSE_TENANT;
        }
        if (person instanceof ISmuggler) {
            return EDialogType.TAVERN_SMUGGLER;
        }
        if (person instanceof ITreasureMapOwner) {
            return EDialogType.TAVERN_TREASUREMAP_OWNER;
        }
        throw new RuntimeException("Unhandled side room person: " + person.getClass().getName());
    }

    protected abstract BooleanBinding disableAcceptButton();

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

