/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernEscortDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernEscortDialog.class);
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientServerFactory clientServerFactory;

    public TavernEscortDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getEscorte());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IEscorte escort = (IEscorte)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                if (this.city.getActiveShip() != null) {
                    IEscorte escort = (IEscorte)this.currentPerson.get();
                    IShip ship = (IShip)this.city.getActiveShip();
                    ship.addPassenger((IPerson)escort);
                    LocalDateTime now = this.date.getCurrentDate();
                    LocalDateTime deadline = escort.getArrivalAtDestinationDate();
                    LinearDeadlinePremiumCalculator premiumCalculator = this.clientServerFactory.premiumCalculator(now, deadline, escort.getPremium());
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{escort.getDestination().getName(), ship.getName(), this.clientServerFactory.dateSupplier(), premiumCalculator});
                    this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), (IPlayer)this.city.getPlayer(), deadline, EDialogTemplateType.ESCORT_LEAVES_SHIP, parameterSupplier, premiumCalculator);
                    this.clientEventBus.post((Object)new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}));
                    escort.leave();
                    this.city.getPlayer().updateCrimialDrive(-1);
                    this.executeOnCloseButtonClicked();
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to accept escorts offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){
            {
                if (TavernEscortDialog.this.city.getActiveShip() instanceof IShip) {
                    ((IShip)TavernEscortDialog.this.city.getActiveShip()).passengerPresentProperty();
                }
            }

            protected boolean computeValue() {
                return !(TavernEscortDialog.this.city.getActiveShip() instanceof IShip) || TavernEscortDialog.this.city.getPlayersShips().isEmpty() || ((IShip)TavernEscortDialog.this.city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }
}

