/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler;

import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.event.data.NewGameClient;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class StartNewGameHandler {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private GameStatus gameStatus;
    @Autowired
    private ViewStatus viewStatus;

    @PostConstruct
    private void initializeEventSystem() {
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleNewGameStart(NewGameClient newGameDTO) {
        Platform.runLater(() -> {
            this.gameStatus.bindToPlayer((IPlayer)newGameDTO.getPlayer());
            this.viewStatus.setCity(newGameDTO.getPlayer().getHometown().getName());
            this.clientServerEventBus.unregister((Object)this);
        });
    }
}

