/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class PassengerLeavesShipOnArrival
extends ShipEntersPortEventListener {
    @Autowired
    @XStreamOmitField
    private DialogTemplateFactory dialogTemplateFactory;
    @Autowired
    private Date date;
    private final IPlayer shipsOwner;
    private final LocalDateTime deadline;
    private final EDialogTemplateType dialogTemplateType;
    private final DialogTemplateParameterSupplier dialogParameterSupplier;
    private final LinearDeadlinePremiumCalculator premiumCalculator;

    public PassengerLeavesShipOnArrival(IShip ship, ICity city, IPlayer shipsOwner, LocalDateTime deadline, EDialogTemplateType dialogType, DialogTemplateParameterSupplier dialogParameterSupplier, LinearDeadlinePremiumCalculator premiumCalculator) {
        super((INavigableVessel)ship, city);
        this.shipsOwner = shipsOwner;
        this.deadline = deadline;
        this.dialogTemplateType = dialogType;
        this.dialogParameterSupplier = dialogParameterSupplier;
        this.premiumCalculator = premiumCalculator;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public boolean execute(ICity city) {
        if (this.ignoreEventCity()) {
            EDialogTemplateType templateType = this.resolveType(this.dialogTemplateType, false);
            DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(templateType, this.dialogParameterSupplier);
            DisplayTemplateMessage message = new DisplayTemplateMessage(EMessageCategory.TRADE, this.getMessageBoardTitleKey(templateType), template, this.getMessageBoardTitleParameters(templateType, city));
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)this.shipsOwner, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        } else {
            if (this.shipsOwner instanceof IHumanPlayer) {
                this.shipsOwner.getCompany().updateCash((long)this.premiumCalculator.get().intValue());
            } else {
                this.shipsOwner.getCompany().updateCashDirectly((long)this.premiumCalculator.get().intValue());
            }
            EDialogTemplateType templateType = this.resolveType(this.dialogTemplateType, true);
            DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(templateType, this.dialogParameterSupplier);
            DisplayTemplateMessage message = new DisplayTemplateMessage(EMessageCategory.TRADE, this.getMessageBoardTitleKey(templateType), template, this.getMessageBoardTitleParameters(templateType, city));
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)this.shipsOwner, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
        ((IShip)this.getShip()).leavePassenger();
        this.unregisterEventBus();
        return true;
    }

    private Object[] getMessageBoardTitleParameters(EDialogTemplateType templateType, ICity city) {
        switch (templateType) {
            case ESCORT_LEAVES_SHIP_AFTER_DEADLINE: 
            case ESCORT_LEAVES_SHIP_BEFORE_DEADLINE: 
            case FUGITIVE_LEAVES_SHIP_AFTER_DEADLINE: 
            case FUGITIVE_LEAVES_SHIP_BEFORE_DEADLINE: 
            case TRAVELER_LEAVES_SHIP_AFTER_DEADLINE: 
            case TRAVELER_LEAVES_SHIP_BEFORE_DEADLINE: {
                return new Object[]{city.getName()};
            }
        }
        return new Object[0];
    }

    private String getMessageBoardTitleKey(EDialogTemplateType templateType) {
        switch (templateType) {
            case ESCORT_LEAVES_SHIP_AFTER_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.unsuccessful.messageboard.title";
            }
            case ESCORT_LEAVES_SHIP_BEFORE_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.successful.messageboard.title";
            }
            case FUGITIVE_LEAVES_SHIP_AFTER_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.unsuccessful.messageboard.title";
            }
            case FUGITIVE_LEAVES_SHIP_BEFORE_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.successful.messageboard.title";
            }
            case TRAVELER_LEAVES_SHIP_AFTER_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.unsuccessful.messageboard.title";
            }
            case TRAVELER_LEAVES_SHIP_BEFORE_DEADLINE: {
                return "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.successful.messageboard.title";
            }
        }
        throw new IllegalArgumentException("Unsupported template type: " + templateType);
    }

    protected boolean ignoreEventCity() {
        return this.date.getCurrentDate().isAfter(this.deadline);
    }

    private EDialogTemplateType resolveType(EDialogTemplateType baseType, boolean successful) {
        switch (baseType) {
            case COURIER_SERVICE_FINISHED: {
                if (successful) {
                    return EDialogTemplateType.COURIER_SERVICE_FINISHED_SUCCESSFUL;
                }
                return EDialogTemplateType.COURIER_SERVICE_FINISHED_UNSUCCESSFUL;
            }
            case ESCORT_LEAVES_SHIP: {
                if (successful) {
                    return EDialogTemplateType.ESCORT_LEAVES_SHIP_BEFORE_DEADLINE;
                }
                return EDialogTemplateType.ESCORT_LEAVES_SHIP_AFTER_DEADLINE;
            }
            case FUGITIVE_LEAVES_SHIP: {
                if (successful) {
                    return EDialogTemplateType.FUGITIVE_LEAVES_SHIP_BEFORE_DEADLINE;
                }
                return EDialogTemplateType.FUGITIVE_LEAVES_SHIP_AFTER_DEADLINE;
            }
            case TRAVELER_LEAVES_SHIP: {
                if (successful) {
                    return EDialogTemplateType.TRAVELER_LEAVES_SHIP_BEFORE_DEADLINE;
                }
                return EDialogTemplateType.TRAVELER_LEAVES_SHIP_AFTER_DEADLINE;
            }
        }
        throw new IllegalArgumentException("Unhandled dialog template type: " + baseType + " for success=" + successful);
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
    }
}

