/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.display.event.data.DelayedTravelToEvent;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TravelToTimedTask
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    private Point2D destination;
    private INavigableVessel vessel;
    @OptionalType(value=ICity.class)
    private Optional<ICity> city;

    public TravelToTimedTask(Point2D destination, INavigableVessel vessel, Optional<ICity> city) {
        this.destination = destination;
        this.vessel = vessel;
        this.city = city;
    }

    @PostConstruct
    private void init() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(5L));
    }

    public void run() {
        this.clientEventBus.post((Object)new DelayedTravelToEvent(this.destination, this.vessel, this.city));
    }

    public String toString() {
        return "TravelToTimedTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + "destination=" + this.destination + ", vessel=" + this.vessel.getUuid() + " " + this.vessel.getName() + "}";
    }
}

