/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.IDisplayableMessage;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.HANDLER})
public class DisplayMessageOverlay
extends VBox {
    private static final Logger log = LoggerFactory.getLogger(DisplayMessageOverlay.class);
    private static final int DISPLAY_MESSAGE_FOR_SECONDS = 15;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations translator;

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleMessage(IDisplayableMessage message) {
        EventHandler<MouseEvent> openDialogEvenHandler;
        Object[] args = message.getMessageArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof EWare)) continue;
            args[i] = this.translator.getLocalDisplayName((IWare)((EWare)args[i]));
        }
        String translatedMessage = this.messageSource.getMessage(message.getMessageKey(), args, this.locale.getCurrentLocal());
        final DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(translatedMessage, this.sizeing);
        if (message instanceof DisplayTemplateMessage) {
            label.setLinkText(true);
            openDialogEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(((DisplayTemplateMessage)message).getDialogTemplate()));
            label.setOnMouseReleased(openDialogEvenHandler);
        } else if (message instanceof DisplayStateMessage) {
            label.setLinkText(true);
            openDialogEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(((DisplayStateMessage)message).getState()));
            label.setOnMouseReleased(openDialogEvenHandler);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    try {
                        FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), (Node)label);
                        ft.setFromValue(1.0);
                        ft.setToValue(0.0);
                        ft.setAutoReverse(false);
                        ft.setOnFinished(event -> DisplayMessageOverlay.this.getChildren().remove((Object)label));
                        ft.play();
                    }
                    catch (RuntimeException e) {
                        log.error("Failed to fade transition", (Throwable)e);
                    }
                });
            }
        };
        this.uiTimer.schedule(task, 15L, TimeUnit.SECONDS);
        Platform.runLater(() -> this.getChildren().add(0, (Object)label));
    }

    private EventHandler<MouseEvent> createEventHandlerFromRunnable(Runnable run) {
        return arg0 -> {
            try {
                run.run();
            }
            catch (RuntimeException e) {
                log.error("Failed to execute runnable", (Throwable)e);
            }
        };
    }
}

