/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.service.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.event.data.DelayedTravelToEvent;
import ch.sahits.game.openpatrician.display.event.data.FocusLocationEvent;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.display.event.task.TravelToTimedTask;
import ch.sahits.game.openpatrician.display.javafx.BaseMainGameImageView;
import ch.sahits.game.openpatrician.engine.sea.AStarGraphProvider;
import ch.sahits.game.openpatrician.engine.sea.LocationTracker;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipLeavingPort;
import ch.sahits.game.openpatrician.event.data.ShipNearingPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.event.data.SwitchCity;
import ch.sahits.game.openpatrician.javafx.bindings.HorizontalScrollBinding;
import ch.sahits.game.openpatrician.javafx.control.CityIcons;
import ch.sahits.game.openpatrician.javafx.control.ShipIcon;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayInfoMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.sea.ITravellingVessels;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.utilities.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.UNRELEVANT_FOR_DESERIALISATION, EClassCategory.SINGLETON_BEAN})
@UniquePrototype
public class SeamapImageView
extends BaseMainGameImageView {
    private static final Logger log = LoggerFactory.getLogger(SeamapImageView.class);
    private int visibleRange = 40;
    private static final int PATH_FADING_DELAY_MS = 5000;
    private final ImageView imgView;
    private Pane shipCanvas;
    private final Rectangle clip;
    private final Rectangle scrollLeft;
    private final Rectangle scrollRight;
    private final Timeline slideLeftAnimation;
    private final Timeline slideRightAnimation;
    private DoubleProperty scale = new SimpleDoubleProperty(1.0);
    @Autowired
    private IMap map;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private AStarGraphProvider aStarGraphService;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    private ITravellingVessels vessels;
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    private EventBus syncServerClientEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;
    @Autowired
    private ShipService shipService;
    @Autowired
    private LocationTracker locationTracker;
    @Autowired
    private IJavaFXApplicationThreadExecution threadExecution;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    @Autowired
    private ClientTaskFactory taskFactory;
    private boolean displayAllShips = false;
    private Image mapImage;
    private final Rectangle slaveClip;
    private Point2D focus;
    private HorizontalScrollBinding scrollBinding;
    @MultimapType(key=INavigableVessel.class, value=INavigableVessel.class)
    private Multimap<INavigableVessel, INavigableVessel> visibleShips = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());

    public SeamapImageView(Image mapImage, double width, double height, Point2D focus, double scale) {
        this.imgView = new ImageView();
        this.shipCanvas = new Pane();
        this.shipCanvas.setId("shipCanvas");
        this.clip = new Rectangle(0.0, 0.0, width, height);
        Color slideColor = new Color(1.0, 1.0, 1.0, 0.1);
        this.slaveClip = new Rectangle(0.0, 0.0, width, height);
        this.scrollLeft = new Rectangle(0.0, 0.0, 50.0, height);
        this.scrollLeft.setFill((Paint)slideColor);
        this.scrollRight = new Rectangle(width - 50.0, 0.0, 50.0, height);
        this.scrollRight.setFill((Paint)slideColor);
        this.slideLeftAnimation = new Timeline();
        this.slideLeftAnimation.setCycleCount(-1);
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)50.0), event -> this.resetClipXPosition(this.clip.getX() - 5.0, this.clip.getWidth()), new KeyValue[0]);
        this.slideLeftAnimation.getKeyFrames().add((Object)kf1);
        this.slideRightAnimation = new Timeline();
        this.slideRightAnimation.setCycleCount(-1);
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)50.0), event -> this.resetClipXPosition(this.clip.getX() + 5.0, this.clip.getWidth()), new KeyValue[0]);
        this.slideRightAnimation.getKeyFrames().add((Object)kf2);
        this.mapImage = mapImage;
        this.focus = focus;
        this.scale.set(scale);
        this.scrollBinding = new HorizontalScrollBinding(this.clip, 0.0);
        log.info("Initialize Sea Map View with focus at {} and scale {}", (Object)focus, (Object)scale);
    }

    @PostConstruct
    private void init() {
        this.clip.xProperty().addListener((observable, oldValue, newValue) -> this.slaveClip.setX(newValue.doubleValue()));
        this.scrollBinding.addListener((observable, oldValue, newValue) -> {
            switch (newValue) {
                case CENTER: {
                    if (!this.getChildren().contains((Object)this.scrollLeft)) {
                        this.getChildren().add((Object)this.scrollLeft);
                    }
                    if (this.getChildren().contains((Object)this.scrollRight)) break;
                    this.getChildren().add((Object)this.scrollRight);
                    break;
                }
                case NO_SCROLL: {
                    this.getChildren().remove((Object)this.scrollLeft);
                    this.getChildren().remove((Object)this.scrollRight);
                    break;
                }
                case ALL_RIGHT: {
                    this.getChildren().remove((Object)this.scrollRight);
                    if (this.getChildren().contains((Object)this.scrollLeft)) break;
                    this.getChildren().add((Object)this.scrollLeft);
                    break;
                }
                case ALL_LEFT: {
                    this.getChildren().remove((Object)this.scrollLeft);
                    if (this.getChildren().contains((Object)this.scrollRight)) break;
                    this.getChildren().add((Object)this.scrollRight);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled state: " + newValue);
                }
            }
        });
        this.clip.yProperty().addListener((observable, oldValue, newValue) -> this.slaveClip.setY(newValue.doubleValue()));
        this.clip.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.slaveClip.setWidth(newValue.doubleValue());
            this.scrollRight.setX(newValue.doubleValue() - this.scrollRight.getWidth());
        });
        this.clip.heightProperty().addListener((observable, oldValue, newValue) -> {
            this.slaveClip.setHeight(newValue.doubleValue());
            this.scrollLeft.setHeight(newValue.doubleValue());
            this.scrollRight.setHeight(newValue.doubleValue());
        });
        this.resetImage(this.mapImage, this.slaveClip.getWidth(), this.slaveClip.getHeight(), this.scale.doubleValue());
        this.imgView.setClip((Node)this.clip);
        this.shipCanvas.setClip((Node)this.slaveClip);
        this.shipCanvas.setMouseTransparent(true);
        this.focusOnPoint(this.focus);
        this.imgView.addEventHandler(MouseEvent.MOUSE_RELEASED, this::handleMouseClick);
        this.scrollLeft.setOnMouseEntered(evt -> {
            if (this.scrolledAllToTheRight(this.clip.getX()) && !this.getChildren().contains((Object)this.scrollRight)) {
                this.getChildren().add((Object)this.scrollRight);
            }
            this.slideLeftAnimation.play();
        });
        this.scrollLeft.setOnMouseExited(evt -> this.slideLeftAnimation.stop());
        this.scrollRight.setOnMouseEntered(evt -> {
            if (this.scrolledAllToTheLeft(this.clip.getX()) && !this.getChildren().contains((Object)this.scrollLeft)) {
                this.getChildren().add((Object)this.scrollLeft);
            }
            this.slideRightAnimation.play();
        });
        this.scrollRight.setOnMouseExited(evt -> this.slideRightAnimation.stop());
        if (!this.scrolledAllToTheLeft(this.clip.getX()) && !this.getChildren().contains((Object)this.scrollLeft)) {
            this.getChildren().add((Object)this.scrollLeft);
        }
        if (!this.scrolledAllToTheRight(this.clip.getX()) && !this.getChildren().contains((Object)this.scrollRight)) {
            this.getChildren().add((Object)this.scrollRight);
        }
        this.initializeVisibleShips();
        this.clientServerEventBus.register((Object)this);
        this.syncServerClientEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
    }

    private void initializeVisibleShips() {
        IHumanPlayer player = this.viewState.getPlayer();
        for (INavigableVessel ship : player.getSelectableVessels()) {
            this.addVisibleVessel(ship, player);
        }
    }

    @VisibleForTesting
    void addVisibleVessel(INavigableVessel ship, IHumanPlayer player) {
        List visibleVessels = this.locationTracker.getShipsInSegments(ship.getLocation(), this.visibleRange);
        for (INavigableVessel visibleVessel : visibleVessels) {
            this.addSingleVisibleVessel(ship, player, visibleVessel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSingleVisibleVessel(INavigableVessel ship, IHumanPlayer player, INavigableVessel visibleVessel) {
        if (!this.isInCity(visibleVessel.getLocation()) && !this.isInCity(ship.getLocation()) && !visibleVessel.getOwner().equals(player) && this.areVisibleToEachOther(visibleVessel, ship)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                if (this.displayAllShips || !this.visibleShips.containsKey((Object)visibleVessel) || !this.visibleShips.containsEntry((Object)visibleVessel, (Object)ship)) {
                    this.visibleShips.put((Object)visibleVessel, (Object)ship);
                }
            }
            if (this.findShipIcon(visibleVessel) == null) {
                this.drawShipOnMap(visibleVessel);
            }
        }
    }

    @PreDestroy
    void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.syncServerClientEventBus.unregister((Object)this);
    }

    private boolean isInCity(Point2D location) {
        return this.map.getCityCoordinates().stream().anyMatch(coord -> coord.equals((Object)location));
    }

    private void handleMouseClick(MouseEvent evt) {
        boolean travelTo = evt.getButton().equals((Object)MouseButton.PRIMARY);
        double unscaledX = Math.round(evt.getX() / this.scale.doubleValue());
        double unscaledY = Math.round(evt.getY() / this.scale.doubleValue());
        Optional<ICity> city = this.findCity(unscaledX, unscaledY);
        travelTo = this.shouldTravelToClickedPosition(travelTo, city);
        ICityPlayerProxyJFX cityProxy = this.viewState.getCurrentCityProxy().get();
        if (travelTo) {
            INavigableVessel vessel = cityProxy.getActiveShip();
            if (vessel instanceof IConvoy && ((IConvoy)vessel).isPublicConvoy()) {
                TravelToTimedTask task = this.taskFactory.getTravelToDelayed(new Point2D(evt.getX(), evt.getY()), vessel, city);
                this.taskList.add((TimedTask)task);
            } else if (this.shipService.checkNumberOfSailors(vessel)) {
                this.travelToDestination(evt.getX(), evt.getY(), city, vessel);
            } else {
                DisplayInfoMessage infoMessage = new DisplayInfoMessage("ch.sahits.game.openpatrician.display.model.DisplayInfoMessage.notEnoughSailors", new Object[]{vessel.getName()});
                this.clientEventBus.post((Object)infoMessage);
            }
        } else if (city.isPresent()) {
            List office = city.get().findBuilding(ITradingOffice.class, Optional.of(this.viewState.getPlayer()));
            List ships = this.viewState.getPlayer().getFleet();
            if (!office.isEmpty()) {
                this.switchToCity(city.get());
            } else {
                for (IShip ship : ships) {
                    if (!ship.getLocation().equals((Object)city.get().getCoordinates())) continue;
                    if (cityProxy.getActiveShip() == null) {
                        cityProxy.arrive((INavigableVessel)ship);
                    }
                    this.switchToCity(city.get());
                    break;
                }
            }
        } else {
            double x = evt.getX();
            double y = evt.getY();
            IHumanPlayer player = this.viewState.getPlayer();
            List shipIcons = this.shipCanvas.getChildren().stream().filter(node -> node instanceof ShipIcon).map(ShipIcon.class::cast).filter(shipIcon -> shipIcon.getPlayer().equals(player)).collect(Collectors.toList());
            for (Node node2 : shipIcons) {
                if (!node2.getBoundsInParent().contains(x, y)) continue;
                String id = node2.getId();
                List fleet = player.getSelectableVessels();
                Optional vessel = this.shipService.findShipByUuid(fleet, id);
                vessel.ifPresent(iNavigableVessel -> cityProxy.activateShip(iNavigableVessel));
            }
        }
    }

    private boolean shouldTravelToClickedPosition(boolean isPrimaryButton, Optional<ICity> city) {
        boolean travelTo = isPrimaryButton;
        if (travelTo && (travelTo = this.viewState.getCurrentCityProxy().isPresent())) {
            EShipType type;
            INavigableVessel activeShip;
            travelTo = city.isPresent() && this.viewState.getCurrentCityProxy().get().getCity().equals(city.get()) ? false : ((activeShip = this.viewState.getCurrentCityProxy().get().getActiveShip()) != null ? (city.isPresent() && city.get().isRiverCity() ? (type = this.shipService.getShipType(activeShip)) != EShipType.COG && type != EShipType.HOLK : true) : false);
        }
        return travelTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void travelToDestination(double x, double y, Optional<ICity> destinationCity, INavigableVessel vessel) {
        double unscaledX = Math.round(x / this.scale.doubleValue());
        double unscaledY = Math.round(y / this.scale.doubleValue());
        Optional<ICity> sourceCity = this.findCity(vessel.getLocation().getX(), vessel.getLocation().getY());
        List path = new ArrayList();
        if (!this.shipService.canReachDestination(vessel, new Point2D(x, y))) {
            DisplayInfoMessage infoMessage = new DisplayInfoMessage("ch.sahits.game.openpatrician.display.model.DisplayInfoMessage.destinationNotReachable", new Object[]{vessel.getName(), destinationCity.get().getName()});
            this.clientEventBus.post((Object)infoMessage);
            return;
        }
        if (this.shipService.isShipTooDamagedToSail(vessel)) {
            DisplayInfoMessage infoMessage = new DisplayInfoMessage("ch.sahits.game.openpatrician.display.model.DisplayInfoMessage.tooDamaged", new Object[]{vessel.getName()});
            this.clientEventBus.post((Object)infoMessage);
            return;
        }
        if (destinationCity.isPresent()) {
            path = this.seafaringService.travelTo(vessel, destinationCity.get().getCoordinates());
        } else {
            Point2D destination = new Point2D(unscaledX, unscaledY);
            if (this.aStarGraphService.isOnSea(destination)) {
                path = this.seafaringService.travelTo(vessel, destination);
            }
        }
        this.drawPath(vessel, path);
        PathInterpolatorMap pathInterpolatorMap = this.interpolators;
        synchronized (pathInterpolatorMap) {
            if (destinationCity.isPresent()) {
                this.interpolators.get((Object)vessel).setDestinationCity(true);
            } else {
                this.interpolators.get((Object)vessel).setDestinationCity(false);
            }
            if (sourceCity.isPresent()) {
                this.interpolators.get((Object)vessel).setSourceCity(true);
            } else {
                this.interpolators.get((Object)vessel).setSourceCity(false);
            }
        }
        if (!sourceCity.isPresent() && this.viewState.getCurrentCityProxy().isPresent()) {
            this.viewState.getCurrentCityProxy().get().leave(vessel);
        }
    }

    private void drawPath(INavigableVessel vessel, List<Point2D> path) {
        if (path != null) {
            this.clearLines();
            Optional p = this.pathConverter.createPath(vessel, path, this.scale.doubleValue());
            if (p.isPresent()) {
                ((Path)p.get()).setId(vessel.getUuid());
                this.drawPathOnMap(vessel, path, (Path)p.get());
            } else {
                log.warn("Path not available for {} of {} {}", new Object[]{vessel.getName(), vessel.getOwner().getName(), vessel.getOwner().getLastName()});
            }
        }
    }

    private void drawPathOnMap(INavigableVessel vessel, List<Point2D> path, final Path p) {
        this.shipCanvas.getChildren().add((Object)p);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), (Node)p);
                    ft.setFromValue(1.0);
                    ft.setToValue(0.0);
                    ft.setAutoReverse(false);
                    ft.setOnFinished(event -> SeamapImageView.this.shipCanvas.getChildren().remove((Object)p));
                    ft.play();
                });
            }
        };
        this.uiTimer.schedule(task, 5000L, TimeUnit.MILLISECONDS);
        this.addNewShipIconToCanvas(vessel, path);
    }

    private void drawShipOnMap(INavigableVessel vessel) {
        List path = this.vessels.getTravellingVessel(vessel).getCalculatablePath();
        this.addNewShipIconToCanvas(vessel, path);
    }

    private void addNewShipIconToCanvas(INavigableVessel vessel, List<Point2D> path) {
        ShipIcon shipIcon = new ShipIcon(vessel, this.viewState.getPlayer(), this.imageLoader);
        shipIcon.scaleProperty().bind((ObservableValue)this.scale);
        shipIcon.updatePosition();
        shipIcon.setTravelingEast(path.get(0).getX() < path.get(path.size() - 1).getX());
        this.removeVesselFromView(vessel);
        this.shipCanvas.getChildren().add((Object)shipIcon);
    }

    private ShipIcon findShipIcon(INavigableVessel vessel) {
        String id = vessel.getUuid();
        for (Node node : this.shipCanvas.getChildrenUnmodifiable()) {
            if (!(node instanceof ShipIcon) || !id.equals(node.getId())) continue;
            return (ShipIcon)node;
        }
        log.trace("The vessel " + vessel.getUuid() + ": " + vessel.getName() + " of " + vessel.getOwner().getClass().getSimpleName() + " " + vessel.getOwner().getName() + " " + vessel.getOwner().getLastName() + " is not visible on the map");
        return null;
    }

    private void clearLines() {
        this.shipCanvas.getChildren().removeIf(node -> node instanceof Shape);
    }

    private void switchToCity(ICity city) {
        this.clientEventBus.post((Object)new SwitchCity(city));
    }

    private Optional<ICity> findCity(double unscaledX, double unscaledY) {
        Point2D p = new Point2D(unscaledX, unscaledY);
        for (ICity city : this.map.getCities()) {
            double distance = p.distance(city.getCoordinates());
            if (!(distance <= 20.0)) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }

    private boolean scrolledAllToTheLeft(double x) {
        return x <= 0.0;
    }

    private boolean scrolledAllToTheRight(double x) {
        return x >= this.imgView.getImage().getWidth() - this.clip.getWidth();
    }

    private void focusOnPoint(Point2D focus) {
        double totalwidth = this.imgView.getImage().getWidth();
        double focusX = focus.getX();
        double clipWidth = this.clip.getWidth();
        double x = Math.min(focusX - clipWidth / 2.0, totalwidth - clipWidth);
        this.resetClipXPosition(x, clipWidth);
        this.focus = focus;
    }

    private void resetClipXPosition(double x, double clipWidth) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x > this.imgView.getImage().getWidth() - clipWidth) {
            x = this.imgView.getImage().getWidth() - clipWidth;
        }
        this.imgView.setLayoutX(-x);
        this.shipCanvas.setLayoutX(-x);
        this.clip.setX(x);
        log.trace("Set clip position={}, view and ship canvas layout: {}", (Object)x, (Object)(-x));
    }

    public void resetImage(Image mapImage, double width, double height, double scale) {
        double oldScale = this.scale.doubleValue();
        this.scale.set(scale);
        this.imgView.setImage(mapImage);
        this.scrollBinding.setTotalWidth(mapImage.getWidth());
        this.shipCanvas.setMaxWidth(mapImage.getWidth());
        this.shipCanvas.setMinWidth(mapImage.getWidth());
        this.shipCanvas.setMaxHeight(mapImage.getHeight());
        this.shipCanvas.setMinHeight(mapImage.getHeight());
        this.getChildren().removeAll((Object[])new Node[]{this.imgView, this.shipCanvas});
        double oldWidth = this.clip.getWidth();
        boolean heightChange = this.clip.getHeight() != height;
        double x = Math.max((width - mapImage.getWidth()) / 2.0, 0.0);
        double y = Math.max((height - mapImage.getHeight()) / 2.0, 0.0);
        if (!heightChange) {
            this.imgView.setLayoutX(x);
            this.shipCanvas.setLayoutX(x);
        }
        this.imgView.setLayoutY(y);
        this.shipCanvas.setLayoutY(y);
        double focuspoint = this.clip.getX() + oldWidth / 2.0;
        double xx = Math.max(0.0, focuspoint - width / 2.0);
        this.resetClipXPosition(xx, width);
        Iterator iterator = this.shipCanvas.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node instanceof Circle) {
                iterator.remove();
            }
            if (!(node instanceof CityIcons)) continue;
            iterator.remove();
        }
        this.drawCityInfo(mapImage, scale, xx);
        this.drawShipsInCities(mapImage, scale, xx);
        for (INavigableVessel vessel : this.vessels) {
            TravellingVessel traveling = this.vessels.getTravellingVessel(vessel);
            if (!this.isVesselVisible(vessel)) continue;
            this.removeVesselFromView(vessel);
            this.drawShipOnMap(traveling.getVessel());
        }
        this.redrawPath(oldScale);
        this.clip.setWidth(width);
        this.clip.setHeight(height);
        this.getChildren().add(0, (Object)this.shipCanvas);
        this.getChildren().add(0, (Object)this.imgView);
        this.scrollRight.setX(width - this.scrollRight.getWidth());
    }

    private void drawCityInfo(Image mapImage, double scale, double x) {
        for (ICity city : this.map.getCities()) {
            if (!(city.getCoordinates().getX() >= x) || !(city.getCoordinates().getX() <= x + mapImage.getWidth())) continue;
            CityIcons cityIcons = new CityIcons(city.getCityState(), this.imageLoader);
            double xPos = (city.getCoordinates().getX() - 20.0) * scale;
            double yPos = (city.getCoordinates().getY() + 20.0 + 5.0) * scale;
            cityIcons.setScaleX(scale);
            cityIcons.setScaleY(scale);
            cityIcons.setLayoutX(xPos);
            cityIcons.setLayoutY(yPos);
            this.shipCanvas.getChildren().add(0, (Object)cityIcons);
        }
    }

    private void drawShipsInCities(Image mapImage, double scale, double x) {
        for (ICity city : this.map.getCities()) {
            List ships;
            if (!(city.getCoordinates().getX() >= x) || !(city.getCoordinates().getX() <= x + mapImage.getWidth()) || (ships = this.viewState.getPlayer().findShips(city)).isEmpty()) continue;
            this.drawShipPresenceInCity(city);
        }
    }

    private void drawShipPresenceInCity(ICity city) {
        int radius = 8;
        int cityX = (int)Math.rint(city.getCoordinates().getX());
        int cityY = (int)Math.rint(city.getCoordinates().getY());
        double lScale = this.scale.doubleValue();
        Circle c = new Circle((double)cityX * lScale, (double)cityY * lScale, (double)radius * lScale, (Paint)Color.WHITE);
        this.shipCanvas.getChildren().add((Object)c);
    }

    @Subscribe
    public void handleShipLeavesCity(ShipLeavingPort event) {
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).isEmpty()) {
            double cityX = (double)((int)Math.rint(city.getCoordinates().getX())) * this.scale.doubleValue();
            double cityY = (double)((int)Math.rint(city.getCoordinates().getY())) * this.scale.doubleValue();
            Iterator iterator = this.shipCanvas.getChildren().iterator();
            while (iterator.hasNext()) {
                Circle c;
                Node node = (Node)iterator.next();
                if (!(node instanceof Circle) || (c = (Circle)node).getCenterX() != cityX || c.getCenterY() != cityY) continue;
                Platform.runLater(iterator::remove);
                break;
            }
        }
    }

    @Subscribe
    public void handleFocusEvent(FocusLocationEvent event) {
        this.threadExecution.execute(() -> this.focusOnPoint(event.getFocus()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handelLoadedNewGame(GameStateChange event) {
        if (event.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                this.visibleShips.clear();
                this.initializeVisibleShips();
            }
        }
    }

    private void redrawPath(double oldScale) {
        double scaleCorrection = 1.0 / oldScale;
        double scale = this.scale.doubleValue() * scaleCorrection;
        log.debug("Rescale path from {} to {}, which is a correction of {}", new Object[]{oldScale, this.scale, scale});
        for (Node node : this.shipCanvas.getChildren()) {
            if (!(node instanceof Path)) continue;
            for (PathElement pathElement : ((Path)node).getElements()) {
                this.rescale(pathElement, scale);
            }
        }
    }

    private void rescale(MoveTo pathElement, double scale) {
        double value = pathElement.getX() * scale;
        pathElement.setX(value);
        value = pathElement.getY() * scale;
        pathElement.setY(value);
    }

    private void rescale(CubicCurveTo pathElement, double scale) {
        double value = pathElement.getX() * scale;
        pathElement.setX(value);
        value = pathElement.getY() * scale;
        pathElement.setY(value);
        value = pathElement.getControlX1() * scale;
        pathElement.setControlX1(value);
        value = pathElement.getControlY1() * scale;
        pathElement.setControlY1(value);
        value = pathElement.getControlX2() * scale;
        pathElement.setControlX2(value);
        value = pathElement.getControlY2() * scale;
        pathElement.setControlY2(value);
    }

    private void rescale(PathElement pathElement, double scale) {
        if (pathElement instanceof MoveTo) {
            this.rescale((MoveTo)pathElement, scale);
        } else if (pathElement instanceof CubicCurveTo) {
            this.rescale((CubicCurveTo)pathElement, scale);
        } else {
            throw new IllegalStateException("Rescaling for " + pathElement.getClass().getName() + " is not implemented");
        }
    }

    @Subscribe
    public void handleShipPositionUpdate(ShipPositionUpdateEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        if (vessel.getOwner().equals(this.viewState.getPlayer())) {
            Preconditions.checkNotNull((Object)ship, (Object)("The travelling vessel instance for " + vessel.getName() + " (" + vessel.getUuid() + ") of " + vessel.getOwner().getName() + " " + vessel.getOwner().getLastName() + " could not be found"));
        }
        if (ship != null) {
            this.threadExecution.execute(() -> {
                if (ship != null) {
                    ShipIcon view = this.findShipIcon(vessel);
                    if (view != null) {
                        view.updatePosition();
                    } else {
                        log.trace("Failed to find vessel with uuid {}", (Object)vessel.getUuid());
                    }
                }
                this.handleVisibilityShips(vessel);
            });
        } else {
            log.debug("Ship ship update for {} ({}) as ship is not a traveling vessel", (Object)vessel.getName(), (Object)vessel.getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVisibilityShips(INavigableVessel vessel) {
        IHumanPlayer player = this.viewState.getPlayer();
        HashSet<INavigableVessel> noLongerVisibleVessels = new HashSet<INavigableVessel>();
        if (vessel.getOwner().equals(player)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                HashSet vessels = new HashSet(this.visibleShips.keySet());
                for (INavigableVessel visibleVessel : vessels) {
                    Collection visibleVessels = this.visibleShips.get((Object)visibleVessel);
                    if (visibleVessels == null || !visibleVessels.contains(vessel)) continue;
                    this.checkVisiblityAndUpdate(vessel, noLongerVisibleVessels, visibleVessel);
                }
            }
            this.addVisibleVessel(vessel, player);
        } else {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                if (this.visibleShips.containsKey((Object)vessel)) {
                    ArrayList seenByVessels = new ArrayList(this.visibleShips.get((Object)vessel));
                    for (INavigableVessel visiblePlayerVessel : seenByVessels) {
                        this.checkVisiblityAndUpdate(visiblePlayerVessel, noLongerVisibleVessels, vessel);
                    }
                }
            }
            List playersVessels = player.getSelectableVessels();
            for (INavigableVessel playersVessel : playersVessels) {
                if (!this.areVisibleToEachOther(playersVessel, vessel)) continue;
                if (this.visibleShips.containsKey((Object)vessel)) {
                    if (this.visibleShips.get((Object)vessel).contains(playersVessel)) continue;
                    this.addSingleVisibleVessel(playersVessel, player, vessel);
                    continue;
                }
                this.addSingleVisibleVessel(playersVessel, player, vessel);
            }
        }
        this.removeNoLongerVisibleVessels(noLongerVisibleVessels);
    }

    private void removeNoLongerVisibleVessels(Set<INavigableVessel> noLongerVisibleVessels) {
        for (INavigableVessel v : noLongerVisibleVessels) {
            this.removeVesselFromView(v);
        }
    }

    private void removeVesselFromView(INavigableVessel v) {
        ShipIcon oldView = this.findShipIcon(v);
        if (oldView != null) {
            this.shipCanvas.getChildren().remove((Object)oldView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVisiblityAndUpdate(INavigableVessel vessel, Set<INavigableVessel> noLongerVisibleVessels, INavigableVessel visibleVessel) {
        if (!this.areVisibleToEachOther(visibleVessel, vessel)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                this.visibleShips.remove((Object)visibleVessel, (Object)vessel);
            }
            noLongerVisibleVessels.add(visibleVessel);
        }
    }

    private boolean areVisibleToEachOther(INavigableVessel vessel1, INavigableVessel vessel2) {
        if (this.displayAllShips) {
            return true;
        }
        double distance = vessel1.getLocation().distance(vessel2.getLocation());
        return distance <= (double)this.visibleRange;
    }

    @Subscribe
    public void handleShipReachesDestination(ShipArrivesAtDestinationEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        Path drawablePath = null;
        if (ship != null) {
            drawablePath = ship.getDrwawablePath();
        } else {
            Optional<Node> optPath = this.shipCanvas.getChildren().stream().filter(node -> node instanceof Path && node.getId().equals(vessel.getUuid())).findFirst();
            if (optPath.isPresent()) {
                drawablePath = (Path)optPath.get();
            }
        }
        if (drawablePath != null) {
            Path path = drawablePath;
            Platform.runLater(() -> this.shipCanvas.getChildren().remove((Object)path));
        }
    }

    @Subscribe
    public void handleShipNearsPort(ShipNearingPortEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        if (ship != null) {
            if (this.vessels.getTravellingVessel(vessel) != null) {
                this.threadExecution.execute(() -> this.removeVesselFromView(vessel));
                if (this.isPlayersVessel(vessel)) {
                    Set<INavigableVessel> noLongerVisible = this.removeVisibleVessel(vessel);
                    for (INavigableVessel v : noLongerVisible) {
                        log.debug("The ship {} ({}) is no longer visible", (Object)v.getName(), (Object)v.getUuid());
                    }
                    Platform.runLater(() -> this.removeNoLongerVisibleVessels(noLongerVisible));
                }
            }
        } else {
            log.debug("Ship ship nearing port for {} ({}) as ship is not a traveling vessel", (Object)vessel.getName(), (Object)vessel.getUuid());
        }
    }

    private boolean isPlayersVessel(INavigableVessel vessel) {
        return this.viewState.getPlayer().equals(vessel.getOwner());
    }

    @Subscribe
    public void handeShipReachesPort(ShipEntersPortEvent event) {
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        Platform.runLater(() -> {
            List ships;
            if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).size() == 1) {
                this.drawShipPresenceInCity(city);
            }
        });
    }

    public void removeShipIcons() {
        this.shipCanvas.getChildren().removeIf(node -> node instanceof ShipIcon);
    }

    private Set<INavigableVessel> removeVisibleVessel(INavigableVessel vessel) {
        HashSet<INavigableVessel> noLongerVisibile = new HashSet<INavigableVessel>();
        if (this.displayAllShips) {
            return noLongerVisibile;
        }
        HashSet keys = new HashSet(this.visibleShips.keySet());
        for (INavigableVessel key : keys) {
            if (key.equals(vessel)) {
                Collection vessels = this.visibleShips.removeAll((Object)key);
                noLongerVisibile.addAll(vessels);
                continue;
            }
            this.visibleShips.remove((Object)key, (Object)vessel);
            if (!this.visibleShips.get((Object)key).isEmpty()) continue;
            noLongerVisibile.addAll(this.visibleShips.removeAll((Object)key));
            noLongerVisibile.add(key);
        }
        return noLongerVisibile;
    }

    private boolean isVesselVisible(INavigableVessel vessel) {
        if (this.displayAllShips) {
            return true;
        }
        if (this.isPlayersVessel(vessel)) {
            return !this.shipService.isNearingCity(vessel);
        }
        return false;
    }

    @Subscribe
    public void handleDelayedTravelAction(DelayedTravelToEvent event) {
        this.removeVesselFromView(event.getVessel());
        this.travelToDestination(event.getDestination().getX(), event.getDestination().getY(), event.getCity(), event.getVessel());
    }

    public void toggleVisibilityAllShips() {
        this.displayAllShips = !this.displayAllShips;
    }
}

