/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class City2ShipJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;
    @Autowired
    private TradeService tradeService;

    public City2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        ICity city = this.transfer.getCity();
        int availableAmountCity = city.getWare(this.ware).getAmount();
        if (availableAmountCity > 0) {
            int amount2Move = this.transfer.getAmount(availableAmountCity);
            IPlayer player = this.transfer.getPlayer();
            INavigableVessel vessel = this.transfer.getVessel();
            int capacity = vessel.getCapacity();
            amount2Move = Math.min(amount2Move, capacity);
            this.tradeService.buyFromCityToShip(vessel, player, city, this.ware, amount2Move, Optional.empty(), Optional.empty(), 0L);
        }
    }
}

