/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.EViewState;
import ch.sahits.game.openpatrician.display.dialog.service.DialogFactory;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ViewStatus
extends Group {
    private static final Logger log = LoggerFactory.getLogger(ViewStatus.class);
    private StringProperty city;
    private DoubleProperty width;
    private Text cityName;
    @Autowired
    private ClientViewState clientViewState;
    @Autowired
    private DialogFactory dialogFactory;
    @Autowired
    private IDataImageLoader imageLoader;
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    @Autowired
    private ApplicationContext context;
    private IDialogContoller dialogContoller;

    public ViewStatus() {
        this.setManaged(false);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm());
        this.city = new SimpleStringProperty((Object)this, "city", "");
        this.width = new SimpleDoubleProperty((Object)this, "controlWidth", 0.0);
    }

    @PostConstruct
    private void init() {
        this.cityName = new Text();
        this.cityName.setLayoutY(10.0);
        this.cityName.setFill((Paint)Color.WHITE);
        this.cityName.getStyleClass().add((Object)"cityName");
        this.cityName.textProperty().bind((ObservableValue)this.city);
        this.cityName.setOnMouseReleased(this.createHistoryDisplayHandler());
        Rectangle placeholder = new Rectangle(this.width.doubleValue(), 50.0);
        placeholder.setFill((Paint)Color.TRANSPARENT);
        placeholder.widthProperty().bind((ObservableValue)this.width);
        StackPane centering = new StackPane();
        centering.prefWidthProperty().bind((ObservableValue)this.width);
        centering.getChildren().add((Object)this.cityName);
        ImageView shipListIcon = new ImageView(this.imageLoader.getImage("icons/64/icon_ship_selection"));
        shipListIcon.setScaleX(0.75);
        shipListIcon.setScaleY(0.75);
        double iconWidth = shipListIcon.getImage().getWidth();
        shipListIcon.setLayoutY(-iconWidth * 0.2);
        shipListIcon.setLayoutX(this.width.doubleValue() - iconWidth - 5.0);
        shipListIcon.layoutXProperty().bind((ObservableValue)this.width.subtract(iconWidth + 5.0));
        shipListIcon.setOnMouseReleased(evt -> {
            Object[] args = new Object[]{EDialogType.SHIP_LIST};
            Runnable runnable1 = (Runnable)this.context.getBean("viewChangeActionRunnable", args);
            runnable1.run();
        });
        this.getChildren().addAll((Object[])new Node[]{placeholder, centering, shipListIcon});
        this.clientViewState.stateProperty().addListener((observable, oldValue, newValue) -> {
            if (this.clientViewState.getState() != EViewState.MAP) {
                this.cityName.textProperty().bind((ObservableValue)this.city);
            } else {
                this.cityName.textProperty().unbind();
                this.cityName.setText("");
            }
        });
    }

    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    private EventHandler<? super MouseEvent> createHistoryDisplayHandler() {
        return mouseEvent -> {
            try {
                if (this.clientViewState.getCurrentCityProxy().isPresent()) {
                    this.clientEventBus.post((Object)new NoticeBoardClose());
                    this.dialogContoller.replaceDialog(EDialogType.CITY_HISTORY, new Object[0]);
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to display history", (Throwable)e);
            }
        };
    }

    private String getHistoryResourceName(String name) {
        return "history." + name;
    }

    public void setCity(String city) {
        this.city.set((Object)city);
    }

    public String getCity() {
        return (String)this.city.get();
    }

    public DoubleProperty widthProperty() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public double getWidth() {
        return this.width.doubleValue();
    }

    public void setFont(Font f) {
        this.cityName.setFont(f);
    }
}

