/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.model;

import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(value={EClassCategory.MODEL})
public class RequiredWareCityStorage {
    private IntegerProperty required;
    private final IntegerProperty inStorage;
    private final IntegerProperty inCity;
    private IntegerBinding buyAmount;
    private IntegerBinding buyPrice;
    private BooleanBinding canBuy;

    public RequiredWareCityStorage(int needed, IntegerProperty inStorageAmount, IntegerProperty inCityAmount, final IWare ware, final ComputablePriceV2 computablePrice) {
        this.required = new SimpleIntegerProperty(needed);
        this.inStorage = inStorageAmount;
        this.inCity = inCityAmount;
        this.buyAmount = new IntegerBinding(){

            protected int computeValue() {
                return Math.max(0, RequiredWareCityStorage.this.required.get() - RequiredWareCityStorage.this.inStorage.get());
            }
        };
        this.canBuy = new BooleanBinding(){

            protected boolean computeValue() {
                return RequiredWareCityStorage.this.required.get() < RequiredWareCityStorage.this.inStorage.get() + RequiredWareCityStorage.this.inCity.get();
            }
        };
        this.buyPrice = new IntegerBinding(){
            {
                super.bind(new Observable[]{RequiredWareCityStorage.this.buyAmount, RequiredWareCityStorage.this.inCity});
            }

            protected int computeValue() {
                if (RequiredWareCityStorage.this.buyAmount.get() > 0) {
                    return computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)RequiredWareCityStorage.this.inCity, RequiredWareCityStorage.this.buyAmount);
                }
                return 0;
            }
        };
    }

    public IntegerProperty requiredProperty() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required.setValue((Number)required);
    }

    public IntegerProperty inStorageProperty() {
        return this.inStorage;
    }

    public IntegerProperty inCityProperty() {
        return this.inCity;
    }

    public Number getBuyAmount() {
        return this.buyAmount.get();
    }

    public IntegerBinding buyAmountProperty() {
        return this.buyAmount;
    }

    public Number getBuyPrice() {
        return this.buyPrice.get();
    }

    public IntegerBinding buyPriceProperty() {
        return this.buyPrice;
    }

    public Boolean getCanBuy() {
        return this.canBuy.get();
    }

    public BooleanBinding canBuyProperty() {
        return this.canBuy;
    }
}

