/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseStartupScene
extends OpenPatricianScene {
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private IImageLoader imsLoader;
    protected ImageView paperScroll;
    protected double untransformedWidth;
    protected double untransformedHeight;
    private SceneChangeable sceneChangeable;

    public BaseStartupScene(Region root) {
        super(root);
    }

    protected abstract String getStyleSheetFilename();

    protected final Pane createBaseSceneLayout() {
        Image img = this.imsLoader.getImage("images/PaperScroll");
        this.paperScroll = new ImageView(img);
        Pane root = (Pane)this.getRoot();
        root.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
        this.untransformedWidth = 560.0;
        this.untransformedHeight = 507.0;
        return root;
    }

    protected final PerspectiveTransform createPerspectiveTransform() {
        return new PerspectiveTransform(185.0, 0.0, 449.0, 19.0, 459.0, 502.0, -20.0, 403.0);
    }

    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    public void changeScene(OpenPatricianScene scene) {
        double oldWidth = 0.0;
        double oldHeight = 0.0;
        double newWidth = this.sceneChangeable.getSceneWidth();
        double newHeight = this.sceneChangeable.getSceneHeight();
        this.sceneChangeable.changeScene(scene);
        scene.widthChange(oldWidth, newWidth);
        scene.heightChange(oldHeight, newHeight);
        if (scene instanceof BaseStartupScene) {
            ((BaseStartupScene)scene).setSceneChangeable(this.sceneChangeable);
        }
    }

    protected static class LabelHoverChangeListener
    implements ChangeListener<Boolean> {
        private final Label label;

        public LabelHoverChangeListener(Label label) {
            this.label = label;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                this.label.getStyleClass().remove((Object)"label-unfocused");
                this.label.getStyleClass().add((Object)"label-focus");
            } else {
                this.label.getStyleClass().remove((Object)"label-focus");
                this.label.getStyleClass().add((Object)"label-unfocused");
            }
        }
    }
}

